/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.genes.moa;

import com.gildedgames.aether.api.entity.genes.GeneRegion;
import com.gildedgames.aether.api.entity.genes.IGeneStorage;
import com.gildedgames.aether.common.entities.genes.DataGene;
import com.gildedgames.aether.common.entities.genes.GenePool;
import com.gildedgames.aether.common.entities.genes.GeneUtil;
import com.gildedgames.aether.common.entities.genes.SimpleGeneStorage;
import com.gildedgames.aether.common.entities.genes.moa.MoaGenePoolDataSet;
import com.gildedgames.aether.common.entities.genes.moa.MoaMarkGene;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;

public class MoaGenePool
extends GenePool
implements NBT {
    private GeneRegion<DataGene<Color>> keratin;
    private GeneRegion<DataGene<Color>> feathers;
    private GeneRegion<DataGene<Color>> eyes;
    private GeneRegion<MoaMarkGene> marks;
    private GeneRegion<DataGene<Integer>> wingStrength;

    public MoaGenePool() {
        this(new SimpleGeneStorage());
    }

    public MoaGenePool(IGeneStorage storage) {
        super(storage);
    }

    @Override
    public void transformFromSeed(int seed) {
        this.getStorage().setSeed(seed);
        this.getStorage().setFatherSeed(seed);
        this.getStorage().setMotherSeed(seed);
        Random r = new Random(this.getStorage().getSeed());
        this.keratin = new GeneRegion<DataGene<Color>>("moaBiology.keratin", MoaGenePoolDataSet.KERATIN.pickRandom(r));
        this.feathers = new GeneRegion<DataGene<Color>>("moaBiology.feathers", MoaGenePoolDataSet.FEATHERS.pickRandom(r));
        this.eyes = new GeneRegion<DataGene<Color>>("moaBiology.eyes", MoaGenePoolDataSet.EYES.pickRandom(r));
        this.marks = new GeneRegion<MoaMarkGene>("moaBiology.marks", MoaGenePoolDataSet.MARKS.pickRandom(r));
        this.wingStrength = new GeneRegion<DataGene<Integer>>("moaBiology.wingStrength", MoaGenePoolDataSet.WING_STRENGTH.pickRandom(r));
        this.getStorage().setShouldRetransform(true);
    }

    @Override
    public void transformFromParents(int seed, int fatherSeed, int motherSeed) {
        this.getStorage().setSeed(seed);
        this.getStorage().setFatherSeed(fatherSeed);
        this.getStorage().setMotherSeed(motherSeed);
        MoaGenePool father = new MoaGenePool(new SimpleGeneStorage());
        MoaGenePool mother = new MoaGenePool(new SimpleGeneStorage());
        father.transformFromSeed(this.getStorage().getFatherSeed());
        mother.transformFromSeed(this.getStorage().getMotherSeed());
        Random r = new Random(this.getStorage().getSeed());
        this.keratin = new GeneRegion("moaBiology.keratin", GeneUtil.evaluateInheritedGene(r, father.keratin, mother.keratin));
        this.feathers = new GeneRegion("moaBiology.feathers", GeneUtil.evaluateInheritedGene(r, father.feathers, mother.feathers));
        this.eyes = new GeneRegion("moaBiology.eyes", GeneUtil.evaluateInheritedGene(r, father.eyes, mother.eyes));
        this.marks = new GeneRegion("moaBiology.marks", GeneUtil.evaluateInheritedGene(r, father.marks, mother.marks));
        this.wingStrength = new GeneRegion("moaBiology.wingStrength", GeneUtil.evaluateInheritedGene(r, father.wingStrength, mother.wingStrength));
        this.getStorage().setShouldRetransform(true);
    }

    @Override
    public List<GeneRegion> createGeneRegions() {
        ArrayList gr = Lists.newArrayList();
        gr.add(this.keratin);
        gr.add(this.feathers);
        gr.add(this.eyes);
        gr.add(this.marks);
        gr.add(this.wingStrength);
        return gr;
    }

    public GeneRegion<DataGene<Color>> getKeratin() {
        return this.keratin;
    }

    public GeneRegion<DataGene<Color>> getFeathers() {
        return this.feathers;
    }

    public GeneRegion<DataGene<Color>> getEyes() {
        return this.eyes;
    }

    public GeneRegion<MoaMarkGene> getMarks() {
        return this.marks;
    }

    public GeneRegion<DataGene<Integer>> getWingStrength() {
        return this.wingStrength;
    }

    public void write(NBTTagCompound output) {
        this.getStorage().write(output);
    }

    public void read(NBTTagCompound input) {
        this.getStorage().read(input);
        GeneUtil.transformFromStorage(this, this.getStorage());
    }
}

