/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.genes;

import com.gildedgames.aether.api.entity.genes.Gene;
import com.gildedgames.aether.api.entity.genes.GeneRegion;
import com.gildedgames.aether.api.entity.genes.IGenePool;
import com.gildedgames.aether.api.entity.genes.IGeneStorage;
import java.util.Random;
import net.minecraft.world.World;

public class GeneUtil {
    private GeneUtil() {
    }

    public static void transformFromStorage(IGenePool pool, IGeneStorage storage) {
        if (storage.getSeed() == storage.getFatherSeed() && storage.getSeed() == storage.getMotherSeed()) {
            pool.transformFromSeed(storage.getSeed());
        } else {
            pool.transformFromParents(storage.getSeed(), storage.getFatherSeed(), storage.getMotherSeed());
        }
    }

    public static <T extends GeneRegion<G>, G extends Gene> G evaluateInheritedGene(Random r, T geneRegion1, T geneRegion2) {
        float inheritenceChance2;
        boolean equalChance;
        float inheritenceChance1 = geneRegion1.gene().inheritance().generateChanceToInherit(r);
        boolean bl = equalChance = inheritenceChance1 == (inheritenceChance2 = geneRegion2.gene().inheritance().generateChanceToInherit(r));
        T chosenToInherit = equalChance ? (r.nextBoolean() ? geneRegion1 : geneRegion2) : (inheritenceChance1 > inheritenceChance2 ? geneRegion1 : geneRegion2);
        return chosenToInherit.gene();
    }

    public static int getRandomSeed(World world) {
        int modifier = world.field_73012_v.nextBoolean() ? 1 : -1;
        return modifier * world.field_73012_v.nextInt(Integer.MAX_VALUE);
    }
}

