/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.genes;

import com.gildedgames.aether.api.entity.damage.IDefenseLevelsHolder;
import com.gildedgames.aether.api.entity.genes.IGenePool;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;

public abstract class EntityGeneticAnimal<T extends IGenePool>
extends EntityAnimal
implements IDefenseLevelsHolder {
    private static final DataParameter<Integer> SEED = EntityDataManager.func_187226_a(EntityGeneticAnimal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FATHER_SEED = EntityDataManager.func_187226_a(EntityGeneticAnimal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MOTHER_SEED = EntityDataManager.func_187226_a(EntityGeneticAnimal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SHOULD_RETRANSFORM = EntityDataManager.func_187226_a(EntityGeneticAnimal.class, (DataSerializer)DataSerializers.field_187198_h);
    private final T genePool = this.createNewGenePool();

    public EntityGeneticAnimal(World world) {
        super(world);
    }

    public abstract T createNewGenePool();

    public T getGenePool() {
        return this.genePool;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SEED, (Object)0);
        this.field_70180_af.func_187214_a(FATHER_SEED, (Object)0);
        this.field_70180_af.func_187214_a(MOTHER_SEED, (Object)0);
        this.field_70180_af.func_187214_a(SHOULD_RETRANSFORM, (Object)false);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.shouldRetransform() && this.field_70170_p.field_72995_K) {
            if (this.getSeed() == this.getFatherSeed() && this.getSeed() == this.getMotherSeed()) {
                this.getGenePool().transformFromSeed(this.getSeed());
            } else {
                this.getGenePool().transformFromParents(this.getSeed(), this.getFatherSeed(), this.getMotherSeed());
            }
            this.setShouldRetransform(false);
        }
    }

    public int getSeed() {
        return (Integer)this.func_184212_Q().func_187225_a(SEED);
    }

    protected void setSeed(int seed) {
        this.func_184212_Q().func_187227_b(SEED, (Object)seed);
    }

    public int getFatherSeed() {
        return (Integer)this.func_184212_Q().func_187225_a(FATHER_SEED);
    }

    protected void setFatherSeed(int seed) {
        this.func_184212_Q().func_187227_b(FATHER_SEED, (Object)seed);
    }

    public int getMotherSeed() {
        return (Integer)this.func_184212_Q().func_187225_a(MOTHER_SEED);
    }

    protected void setMotherSeed(int seed) {
        this.func_184212_Q().func_187227_b(MOTHER_SEED, (Object)seed);
    }

    protected boolean shouldRetransform() {
        return (Boolean)this.func_184212_Q().func_187225_a(SHOULD_RETRANSFORM);
    }

    protected void setShouldRetransform(boolean flag) {
        this.func_184212_Q().func_187227_b(SHOULD_RETRANSFORM, (Object)flag);
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("seed", this.getSeed());
        tag.func_74768_a("fatherSeed", this.getFatherSeed());
        tag.func_74768_a("motherSeed", this.getMotherSeed());
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        int seed = tag.func_74762_e("seed");
        int fatherSeed = tag.func_74762_e("fatherSeed");
        int motherSeed = tag.func_74762_e("motherSeed");
        if (seed == fatherSeed && seed == motherSeed) {
            this.getGenePool().transformFromSeed(seed);
        } else {
            this.getGenePool().transformFromParents(seed, fatherSeed, motherSeed);
        }
    }
}

