/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.flying;

import com.gildedgames.aether.api.entity.damage.IDefenseLevelsHolder;
import com.gildedgames.aether.common.entities.ai.EntityAIForcedWander;
import com.gildedgames.aether.common.entities.flying.EntityBodyHelperFlying;
import com.gildedgames.aether.common.entities.flying.FlyingMoveHelper;
import com.gildedgames.aether.common.entities.flying.PathNavigateFlyer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFlying
extends EntityCreature
implements IDefenseLevelsHolder {
    private static final DataParameter<Boolean> IS_MOVING = EntityDataManager.func_187226_a(EntityFlying.class, (DataSerializer)DataSerializers.field_187198_h);
    private final float clientSideTailAnimationO;
    private float clientSideTailAnimationSpeed;
    private float clientSideTailAnimation;

    public EntityFlying(World world) {
        super(world);
        this.func_70105_a(0.85f, 0.85f);
        this.field_70765_h = new FlyingMoveHelper(this);
        this.clientSideTailAnimationO = this.clientSideTailAnimation = this.field_70146_Z.nextFloat();
    }

    protected EntityAIBase createWanderTask() {
        EntityAIForcedWander wander = new EntityAIForcedWander(this, 0.4, 5);
        wander.func_75248_a(1);
        return wander;
    }

    protected void func_184651_r() {
        EntityAIMoveTowardsRestriction moveTowardsRestriction = new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.4);
        moveTowardsRestriction.func_75248_a(1);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)moveTowardsRestriction);
        this.field_70714_bg.func_75776_a(2, this.createWanderTask());
    }

    protected EntityBodyHelper func_184650_s() {
        return new EntityBodyHelperFlying((EntityLivingBase)this);
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailAnimation(float deltaTime) {
        return this.clientSideTailAnimationO + (this.clientSideTailAnimation - this.clientSideTailAnimationO) * deltaTime;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151579_a ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70601_bi() {
        IBlockState state = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        if (!state.func_189884_a((Entity)this)) return false;
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (!(this.func_180484_a(this.field_70170_p.func_175672_r(blockPos)) >= 0.0f)) return false;
        return true;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    protected void func_70664_aZ() {
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_MOVING, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70143_R = 0.0f;
        if (this.field_70122_E) {
            this.field_70181_x += 0.1;
            this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
            this.field_70122_E = false;
            this.field_70160_al = true;
        }
        if (this.field_70123_F || this.field_70124_G || !this.func_70058_J()) {
            this.field_70159_w += (double)(this.field_70146_Z.nextBoolean() ? 1.0f : -1.0f) * (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f);
            this.field_70179_y += (double)(this.field_70146_Z.nextBoolean() ? 1.0f : -1.0f) * (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f);
        }
        if (this.field_70170_p.field_72995_K) {
            this.clientSideTailAnimationSpeed = this.isMoving() ? (this.clientSideTailAnimationSpeed < 0.5f ? 4.0f : (this.clientSideTailAnimationSpeed += (0.5f - this.clientSideTailAnimationSpeed) * 0.1f)) : (this.clientSideTailAnimationSpeed += (0.125f - this.clientSideTailAnimationSpeed) * 0.2f);
            this.clientSideTailAnimation += this.clientSideTailAnimationSpeed;
        }
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateFlyer((EntityLiving)this, worldIn);
    }

    public boolean isMoving() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_MOVING);
    }

    protected void setMoving(boolean moving) {
        this.field_70180_af.func_187227_b(IS_MOVING, (Object)moving);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 1;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70613_aW()) {
            super.func_191958_b(strafe, vertical, forward, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }
}

