/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.effects;

import com.gildedgames.aether.api.entity.effects.EEffectIntensity;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffects;
import com.gildedgames.aether.common.entities.effects.StatusEffect;
import java.util.Collection;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.text.TextFormatting;

public class StatusEffectStun
extends StatusEffect {
    private EntityLivingBase affectedEntity;

    public StatusEffectStun(EntityLivingBase livingBase) {
        super(IAetherStatusEffects.effectTypes.STUN, new AttributeModifier("aether.statusEffectStun", -0.25, 1).func_111168_a(false), livingBase);
        this.affectedEntity = livingBase;
    }

    @Override
    public void applyEffect(EntityLivingBase livingBase, int timer) {
        if (this.isEffectApplied) {
            IAttributeInstance iAttributeInstance = livingBase.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (iAttributeInstance != null && !iAttributeInstance.func_180374_a(this.getAttributeModifier())) {
                iAttributeInstance.func_111121_a(this.getAttributeModifier());
            }
        } else {
            IAttributeInstance iAttributeInstance = livingBase.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (iAttributeInstance != null && iAttributeInstance.func_111127_a(this.getAttributeModifier().func_111167_a()) != null) {
                iAttributeInstance.func_111124_b(this.getAttributeModifier());
            }
        }
    }

    @Override
    public void onEffectEnd() {
        EntityLivingBase livingBase = this.affectedEntity;
        IAttributeInstance iAttributeInstance = livingBase.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (iAttributeInstance != null && iAttributeInstance.func_111127_a(this.getAttributeModifier().func_111167_a()) != null) {
            iAttributeInstance.func_111124_b(this.getAttributeModifier());
        }
    }

    @Override
    public int getBuildupFromIntensity(EEffectIntensity intensity) {
        switch (intensity) {
            case MINOR: {
                return 25;
            }
            case ORDINARY: {
                return 60;
            }
            case MAJOR: {
                return 90;
            }
        }
        return 0;
    }

    @Override
    public void addInformation(Collection<String> label) {
        label.add(TextFormatting.GOLD.toString() + I18n.func_135052_a((String)"effect.aether.stun", (Object[])new Object[0]));
    }
}

