/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.effects;

import com.gildedgames.aether.api.entity.effects.EEffectIntensity;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffects;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.effects.PacketStatusEffect;
import com.gildedgames.aether.common.util.helpers.EntityUtil;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class StatusEffect
implements IAetherStatusEffects {
    protected final String NAME;
    protected int REDUCTION_RATE;
    protected int TIME_TILL_REDUCTION;
    protected int ACTIVE_EFFECT_TIME;
    protected int BUILDUP_SPEED;
    private final AttributeModifier ATTRIBUTE_MODIFIER;
    protected boolean stopTimer;
    protected int effectBuildup;
    protected int effectTimer;
    protected int decreaseTimer;
    protected double effectResistance = 1.0;
    protected double tempEffectResistance = 0.0;
    protected IAetherStatusEffects.effectTypes effectType;
    protected boolean isEffectApplied;
    protected double activeEffectTimeModifier = 1.0;
    protected boolean isDirty;
    protected int potentialBuildup;
    protected float textAlpha = 1.0f;
    private final EntityLivingBase livingEffected;

    public StatusEffect(IAetherStatusEffects.effectTypes effectType, AttributeModifier attributeModifier, EntityLivingBase living) {
        this.effectType = effectType;
        this.isEffectApplied = false;
        this.NAME = effectType.name;
        this.REDUCTION_RATE = effectType.reductionRate;
        this.TIME_TILL_REDUCTION = effectType.timeTillReduction;
        this.ACTIVE_EFFECT_TIME = effectType.activeEffectTime;
        this.BUILDUP_SPEED = effectType.buildupSpeed;
        this.ATTRIBUTE_MODIFIER = attributeModifier;
        this.livingEffected = living;
        this.isDirty = false;
    }

    @Override
    public void tick(EntityLivingBase livingBase) {
        if (this.effectBuildup < this.potentialBuildup) {
            this.effectBuildup += this.BUILDUP_SPEED;
            EntityUtil.spawnEffectParticles(livingBase, this.effectType);
        }
        if (this.effectBuildup >= this.potentialBuildup) {
            this.potentialBuildup = 0;
        }
        if (this.effectBuildup > 0 || this.isEffectApplied) {
            this.markDirty();
        }
        if (this.effectBuildup >= 101) {
            this.isEffectApplied = true;
            this.effectBuildup = 100;
            this.potentialBuildup = 0;
        }
        this.applyEffect(livingBase, this.effectTimer);
        if (this.effectBuildup < 100) {
            this.decreaseTimer = 0;
        }
        if (this.isEffectApplied) {
            ++this.decreaseTimer;
            EntityUtil.spawnEffectParticles(livingBase, this.effectType);
            if ((double)this.decreaseTimer >= (double)(this.ACTIVE_EFFECT_TIME * 20) * this.activeEffectTimeModifier) {
                this.resetEffect();
            }
        }
        this.reduceBuildup();
        if (this.effectBuildup <= 0) {
            if (!this.isEffectApplied) {
                this.effectTimer = 0;
            }
            this.effectBuildup = 0;
        }
        if (this.isDirty) {
            if (livingBase instanceof EntityPlayerMP) {
                NetworkingAether.sendPacketToPlayer(new PacketStatusEffect((Entity)livingBase), (EntityPlayerMP)livingBase);
                this.markClean();
            } else {
                this.markClean();
            }
        }
    }

    @Override
    public abstract void applyEffect(EntityLivingBase var1, int var2);

    @Override
    public abstract void onEffectEnd();

    @Override
    public void addBuildup(int buildup, double additionalResistance) {
        if (!this.isEffectApplied) {
            this.tempEffectResistance = additionalResistance;
            this.potentialBuildup = this.effectBuildup + MathHelper.func_76143_f((double)((double)buildup * this.calculateResistances()));
            if (additionalResistance > 0.0) {
                this.markDirty();
            }
            if (this.potentialBuildup >= 100) {
                this.potentialBuildup = 101;
            }
            this.effectTimer = 0;
        }
    }

    @Override
    public double calculateResistances() {
        double ret = this.effectResistance + this.tempEffectResistance;
        return MathHelper.func_151237_a((double)ret, (double)0.0, (double)2.0);
    }

    @Override
    public void adjustDecrease(int reductionRate) {
        this.REDUCTION_RATE = reductionRate;
    }

    @Override
    public void resetDecrease() {
        this.REDUCTION_RATE = this.effectType.reductionRate;
    }

    @Override
    public void setBuildup(int buildup) {
        this.effectBuildup = buildup;
    }

    @Override
    public void setApplied(boolean isApplied) {
        this.isEffectApplied = isApplied;
    }

    @Override
    public void reduceBuildup() {
        if (this.effectBuildup > 0) {
            ++this.effectTimer;
            if (!this.isEffectApplied && this.effectTimer % (this.TIME_TILL_REDUCTION * 20) == 0) {
                if (this.effectBuildup < this.potentialBuildup) {
                    this.potentialBuildup -= this.REDUCTION_RATE;
                } else {
                    this.effectBuildup -= this.REDUCTION_RATE;
                }
            }
        }
    }

    @Override
    public void addResistance(double addResistance) {
        this.markDirty();
        if (this.effectResistance + addResistance >= 2.0) {
            this.effectResistance = 2.0;
            return;
        }
        if (this.effectResistance + addResistance <= 0.0) {
            this.effectResistance = 0.0;
            return;
        }
        this.effectResistance += addResistance;
    }

    @Override
    public void resetResistance() {
        this.effectResistance = 1.0;
        this.tempEffectResistance = 0.0;
        this.markDirty();
    }

    @Override
    public void setActiveEffectTimeModifier(double activeEffectTimeModifier) {
        this.activeEffectTimeModifier = activeEffectTimeModifier;
    }

    @Override
    public double getResistance() {
        return this.effectResistance;
    }

    @Override
    public void resetEffect() {
        this.onEffectEnd();
        this.isEffectApplied = false;
        this.effectBuildup = 0;
        this.effectTimer = 0;
        this.activeEffectTimeModifier = 1.0;
        this.potentialBuildup = 0;
        this.tempEffectResistance = 0.0;
        this.decreaseTimer = 0;
        this.markDirty();
    }

    @Override
    public int getBuildup() {
        return this.effectBuildup;
    }

    @Override
    public int getTimer() {
        return this.decreaseTimer;
    }

    @Override
    public int getActiveEffectTime() {
        return this.ACTIVE_EFFECT_TIME;
    }

    @Override
    public double getActiveEffectTimeModifier() {
        return this.activeEffectTimeModifier;
    }

    @Override
    public boolean getIsEffectApplied() {
        return this.isEffectApplied;
    }

    @Override
    public IAetherStatusEffects.effectTypes getEffectType() {
        return this.effectType;
    }

    @Override
    public String getEffectName() {
        return this.NAME;
    }

    @Override
    public AttributeModifier getAttributeModifier() {
        return this.ATTRIBUTE_MODIFIER;
    }

    @Override
    public abstract int getBuildupFromIntensity(EEffectIntensity var1);

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void markDirty() {
        this.isDirty = true;
    }

    @Override
    public void markClean() {
        this.isDirty = false;
    }

    @Override
    public float getEffectTextAlpha() {
        this.textAlpha = this.getTimer() > 50 && this.getTimer() < 60 ? (this.textAlpha > 0.05f ? (this.textAlpha -= 0.04f) : 0.0f) : (this.getTimer() <= 50 & this.getTimer() >= 0 ? 1.0f : 0.0f);
        return this.textAlpha;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract void addInformation(Collection<String> var1);

    public void write(NBTTagCompound compound) {
        compound.func_74768_a(this.NAME + ".effectBuildup", this.effectBuildup);
        compound.func_74757_a(this.NAME + ".effectIsApplied", this.isEffectApplied);
        compound.func_74768_a(this.NAME + ".effectTimer", this.effectTimer);
        compound.func_74768_a(this.NAME + ".decreaseTimer", this.decreaseTimer);
        compound.func_74780_a(this.NAME + ".effectActiveTimeModifier", this.activeEffectTimeModifier);
    }

    public void read(NBTTagCompound compound) {
        this.effectBuildup = compound.func_74762_e(this.NAME + ".effectBuildup");
        this.isEffectApplied = compound.func_74767_n(this.NAME + ".effectIsApplied");
        this.effectTimer = compound.func_74762_e(this.NAME + ".effectTimer");
        this.decreaseTimer = compound.func_74762_e(this.NAME + ".decreaseTimer");
        this.activeEffectTimeModifier = compound.func_74762_e(this.NAME + ".effectActiveTimeModifier");
    }
}

