/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.effects;

import com.gildedgames.aether.api.player.IPlayerAether;
import java.util.function.Function;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class InventoryProvider {
    private ResourceLocation uniqueId;
    private Function<IPlayerAether, IInventory> inventoryFunction;

    public InventoryProvider(ResourceLocation uniqueId, Function<IPlayerAether, IInventory> inventoryFunction) {
        this.uniqueId = uniqueId;
        this.inventoryFunction = inventoryFunction;
    }

    public IInventory provide(IPlayerAether playerAether) {
        return this.inventoryFunction.apply(playerAether);
    }

    public ResourceLocation getUniqueId() {
        return this.uniqueId;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uniqueId).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof InventoryProvider) {
            InventoryProvider other = (InventoryProvider)obj;
            return new EqualsBuilder().append((Object)this.uniqueId, (Object)other.uniqueId).isEquals();
        }
        return false;
    }
}

