/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.effects;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.items.equipment.effects.EffectInstance;
import com.gildedgames.aether.api.items.equipment.effects.IEffectFactory;
import com.gildedgames.aether.api.items.equipment.effects.IEffectPool;
import com.gildedgames.aether.api.items.equipment.effects.IEffectPrecondition;
import com.gildedgames.aether.api.items.equipment.effects.IEffectProvider;
import com.gildedgames.aether.api.player.IPlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.entities.effects.InventoryProvider;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class EquipmentEffectPool<T extends IEffectProvider>
implements IEffectPool<T> {
    private final IPlayerAether player;
    private final Multimap<Pair<Integer, InventoryProvider>, T> providers = HashMultimap.create();
    private final Map<T, Pair<Integer, InventoryProvider>> providersInverse = new HashMap<T, Pair<Integer, InventoryProvider>>();
    private final HashSet<T> active = new HashSet();
    private final IEffectFactory<T> factory;
    private final boolean isRemote;
    private EffectInstance instance;

    public EquipmentEffectPool(IPlayerAether player, IEffectFactory<T> factory) {
        this.player = player;
        this.factory = factory;
        this.isRemote = player.getEntity().func_130014_f_().field_72995_K;
    }

    public void update() {
        this.providers.forEach(this::updateProvider);
        if (this.instance != null && !this.isRemote) {
            this.instance.onEntityUpdate(this.player);
        }
    }

    public void onTeleport() {
        this.rebuildInstance();
    }

    private void updateProvider(Pair<Integer, InventoryProvider> inventoryIndexPair, T provider) {
        PlayerAether playerAether = PlayerAether.getPlayer(this.player.getEntity());
        Integer index = (Integer)inventoryIndexPair.getKey();
        InventoryProvider inventoryProvider = (InventoryProvider)inventoryIndexPair.getValue();
        ItemStack stack = inventoryProvider.provide(playerAether).func_70301_a(index.intValue());
        Collection<IEffectPrecondition> preconditions = AetherAPI.content().items().getProperties(stack.func_77973_b()).getEffectPreconditions();
        boolean match = preconditions.stream().allMatch(e -> e.canApply(this.player, stack));
        if (preconditions.size() <= 0 || match) {
            if (this.active.add(provider)) {
                this.rebuildInstance();
            }
        } else if (this.active.remove(provider)) {
            this.rebuildInstance();
        }
    }

    public void removeInstances(Pair<Integer, InventoryProvider> inventoryIndexPair) {
        Collection provider = this.providers.removeAll(inventoryIndexPair);
        if (provider == null || provider.isEmpty()) {
            return;
        }
        for (IEffectProvider inst : provider) {
            this.active.remove(inst);
            this.providersInverse.remove(inst);
        }
        this.rebuildInstance();
    }

    public void addInstance(Pair<Integer, InventoryProvider> inventoryIndexPair, T provider) {
        this.providers.put(inventoryIndexPair, provider);
        this.providersInverse.put(provider, inventoryIndexPair);
        this.updateProvider(inventoryIndexPair, provider);
    }

    private void rebuildInstance() {
        if (this.instance != null && !this.isRemote) {
            this.instance.onInstanceRemoved(this.player);
        }
        this.instance = this.factory.createInstance(this);
        if (!this.isRemote) {
            this.instance.onInstanceAdded(this.player);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.active.size() <= 0;
    }

    @Override
    public ItemStack getProvider(T provider) {
        Pair<Integer, InventoryProvider> inventoryIndexPair = this.providersInverse.get(provider);
        return ((InventoryProvider)inventoryIndexPair.getValue()).provide(this.player).func_70301_a(((Integer)inventoryIndexPair.getKey()).intValue());
    }

    @Override
    public Collection<T> getActiveProviders() {
        return this.active;
    }

    @Override
    public Optional<EffectInstance> getInstance() {
        return Optional.ofNullable(this.instance);
    }
}

