/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.companions;

import com.gildedgames.aether.common.entities.ai.companion.EntityAICompanionFollow;
import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class EntityCompanion
extends EntityCreature {
    private static final DataParameter<Optional<UUID>> OWNER_UUID = new DataParameter(20, DataSerializers.field_187203_m);
    protected boolean isFlying = false;
    private boolean wasDespawned = false;

    public EntityCompanion(World worldIn) {
        super(worldIn);
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target == this.getOwner()) {
            return;
        }
        super.func_70624_b(target);
    }

    protected void func_184651_r() {
        EntityAICompanionFollow follow = new EntityAICompanionFollow(this);
        follow.func_75248_a(1);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)follow);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UUID, (Object)Optional.absent());
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if (!this.isFlying) {
            super.func_180429_a(pos, blockIn);
        }
    }

    public boolean func_70041_e_() {
        return !this.isFlying;
    }

    public boolean func_70692_ba() {
        return false;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this.getOwner() == null || this.getOwner().field_70128_L)) {
            this.func_70106_y();
            this.wasDespawned = true;
        }
        super.func_70071_h_();
        this.field_70143_R = 0.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity attacker = source.func_76346_g();
        if (attacker != null && attacker == this.getOwner()) {
            return super.func_70097_a(source, 0.0f);
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_82167_n(Entity entity) {
        if (entity != this.getOwner()) {
            entity.func_70108_f((Entity)this);
        }
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    public void func_181015_d(BlockPos pos) {
    }

    public EntityPlayer getOwner() {
        Optional uuid = (Optional)this.field_70180_af.func_187225_a(OWNER_UUID);
        if (!uuid.isPresent()) {
            return null;
        }
        return this.field_70170_p.func_152378_a((UUID)uuid.get());
    }

    public void setOwner(EntityPlayer owner) {
        this.field_70180_af.func_187227_b(OWNER_UUID, (Object)(owner == null ? Optional.absent() : Optional.of((Object)owner.func_110124_au())));
    }

    public boolean wasDespawned() {
        return this.wasDespawned;
    }

    public void setDespawned(boolean despawned) {
        this.wasDespawned = despawned;
    }
}

