/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.characters;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.entity.EntityCharacter;
import com.gildedgames.aether.api.shop.IShopDefinition;
import com.gildedgames.aether.api.shop.IShopInstance;
import com.gildedgames.aether.api.shop.IShopInstanceGroup;
import com.gildedgames.aether.common.AetherCelebrations;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerDialogModule;
import com.gildedgames.aether.common.shop.ShopInstanceGroup;
import com.gildedgames.orbis.lib.util.mc.NBTHelper;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMysteriousFigure
extends EntityCharacter {
    public static final ResourceLocation SPEAKER = AetherCore.getResource("mysterious_figure");
    private BlockPos spawned;

    public EntityMysteriousFigure(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 2.0f);
    }

    @Override
    public IShopInstanceGroup createShopInstanceGroup() {
        ShopInstanceGroup group = new ShopInstanceGroup();
        Optional<IShopDefinition> shopDefinition = AetherAPI.content().shop().getShopDefinition(SPEAKER);
        if (shopDefinition.isPresent()) {
            IShopInstance instance = AetherAPI.content().shop().createInstance(SPEAKER, shopDefinition.get(), new Random(this.func_70681_au().nextLong()));
            group.setShopInstance(0, instance);
        }
        return group;
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
    }

    protected EntityBodyHelper func_184650_s() {
        return new EntityBodyHelper((EntityLivingBase)this);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 50.0f, 1.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("spawned", NBTHelper.writeBlockPos((BlockPos)this.spawned));
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.spawned = NBTHelper.readBlockPos((NBTTagCompound)compound.func_74775_l("spawned"));
        if (this.spawned != null) {
            this.func_175449_a(this.spawned, 3);
        }
    }

    protected void func_70101_b(float yaw, float pitch) {
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70082_c(float yaw, float pitch) {
    }

    @Override
    public void func_70071_h_() {
        if (!AetherCelebrations.isHalloweenEvent()) {
            if (this.field_70130_N > 0.0f && this.field_70131_O > 0.0f) {
                this.func_70105_a(0.0f, 0.0f);
            }
        } else if (this.field_70130_N == 0.0f && this.field_70131_O == 0.0f) {
            this.func_70105_a(1.0f, 2.0f);
        }
        this.field_70165_t = this.field_70169_q;
        this.field_70161_v = this.field_70166_s;
        if (this.spawned == null) {
            this.spawned = this.func_180425_c();
            this.func_175449_a(this.spawned, 3);
        }
        super.func_70071_h_();
        this.field_70165_t = this.field_70169_q;
        this.field_70161_v = this.field_70166_s;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        LocalDateTime time = LocalDateTime.now();
        if (time.getMonth() != Month.OCTOBER) {
            return false;
        }
        if (!super.func_184645_a(player, hand)) {
            PlayerAether playerAether = PlayerAether.getPlayer(player);
            PlayerDialogModule dialogModule = playerAether.getModule(PlayerDialogModule.class);
            dialogModule.setTalkingEntity(this);
            if (!player.field_70170_p.field_72995_K) {
                dialogModule.openScene(AetherCore.getResource("mysterious_figure/start"), "start");
            }
        }
        return true;
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    protected boolean func_70041_e_() {
        return false;
    }
}

