/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.blocks;

import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerParachuteModule;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityParachute
extends Entity {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityParachute.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityPlayer parachutingPlayer;
    private int parachuteTimer;

    public EntityParachute(World world) {
        super(world);
        this.func_70106_y();
    }

    public EntityParachute(World world, EntityPlayer player, Type type) {
        super(world);
        this.setType(type);
        this.parachutingPlayer = player;
        this.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
    }

    public void func_70088_a() {
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_184187_bx() == null) {
            this.func_184205_a((Entity)this.parachutingPlayer, true);
        }
        if (!(this.field_70128_L || this.getType() != Type.BLUE && this.getType() != Type.PURPLE)) {
            ++this.parachuteTimer;
        }
        if (this.func_184187_bx() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.func_184187_bx();
            Vec3d vec3 = player.func_70040_Z();
            PlayerAether playerAether = PlayerAether.getPlayer(player);
            int blueParachuteAbilityTime = 20;
            int purpleParachuteAbilityTime = 90;
            if (this.getType() == Type.COLD) {
                player.field_70181_x = !player.func_70093_af() ? -0.08 : -0.24;
            }
            if (this.getType() == Type.BLUE) {
                if (this.parachuteTimer <= blueParachuteAbilityTime) {
                    player.field_70181_x = 1.08;
                } else {
                    this.replaceParachute(player, playerAether);
                }
            }
            if (this.getType() == Type.PURPLE) {
                if (this.parachuteTimer <= purpleParachuteAbilityTime) {
                    player.field_70159_w = vec3.field_72450_a * 0.36;
                    player.field_70181_x = 0.0;
                    player.field_70179_y = vec3.field_72449_c * 0.36;
                } else if (this.parachuteTimer > purpleParachuteAbilityTime + 2) {
                    this.replaceParachute(player, playerAether);
                }
            }
            player.field_70160_al = true;
            if (this.getType() == Type.BLUE && playerAether.getModule(PlayerParachuteModule.class).isUnderABlock((int)player.field_70163_u)) {
                this.replaceParachute(player, playerAether);
            }
            if (player.field_70122_E && this.getType() != Type.BLUE) {
                playerAether.getModule(PlayerParachuteModule.class).setParachuting(false, this.getType());
            }
            if (!playerAether.getModule(PlayerParachuteModule.class).isParachuting() || playerAether.getModule(PlayerParachuteModule.class).getParachuteEquipped()) {
                this.destroyParachute(playerAether);
            }
            if (player.field_71071_by.func_70301_a(playerAether.getModule(PlayerParachuteModule.class).getParachuteItemSlot()).func_190926_b()) {
                playerAether.getModule(PlayerParachuteModule.class).setParachuting(false, this.getType());
                this.destroyParachute(playerAether);
            }
        }
    }

    public void replaceParachute(EntityPlayer player, PlayerAether playerAether) {
        playerAether.getModule(PlayerParachuteModule.class).setParachuting(true, Type.COLD);
        this.setType(Type.COLD);
    }

    public void destroyParachute(PlayerAether playerAether) {
        this.parachuteTimer = 0;
        this.func_70106_y();
        playerAether.getModule(PlayerParachuteModule.class).parachuteEquipped(false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public Type getType() {
        return Type.fromOrdinal((Integer)this.field_70180_af.func_187225_a(TYPE));
    }

    public void setType(Type type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type.ordinal());
    }

    public EntityPlayer getParachutingPlayer() {
        return this.parachutingPlayer;
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.setType(Type.fromOrdinal(tag.func_74762_e("type")));
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("type", this.getType().ordinal());
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return source.func_76346_g() != this.func_184187_bx();
    }

    public static enum Type {
        COLD("cold"),
        PURPLE("purple"),
        BLUE("blue");

        public final String name;
        public final String desc;
        public final ResourceLocation texture;

        private Type(String name) {
            this.name = name;
            this.desc = "cloudParachute.ability." + this.name;
            this.texture = AetherCore.getResource("textures/entities/parachute/parachute_" + this.name + ".png");
        }

        public static Type fromOrdinal(int ordinal) {
            Type[] type;
            return type[ordinal >= (type = Type.values()).length || ordinal < 0 ? 0 : ordinal];
        }
    }
}

