/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.blocks;

import com.gildedgames.aether.api.chunk.IPlacementFlagCapability;
import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMovingBlock
extends Entity {
    private static final DataParameter<Integer> BLOCK_NAME = new DataParameter(20, DataSerializers.field_187192_b);
    private static final DataParameter<Byte> BLOCK_METADATA = new DataParameter(21, DataSerializers.field_187191_a);
    private EntityPlayer holdingPlayer;
    private boolean hasActivated = false;
    private boolean allowDoubleDrops = true;
    private int ticksStuck = 0;
    private int ticksFalling = 0;

    public EntityMovingBlock(World world) {
        super(world);
        this.func_70105_a(0.9f, 0.9f);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public EntityMovingBlock(World world, double x, double y, double z, IBlockState state) {
        this(world);
        this.setBlockState(state);
        this.func_70107_b(x, y, z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BLOCK_NAME, (Object)2);
        this.field_70180_af.func_187214_a(BLOCK_METADATA, (Object)4);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        if (this.field_70177_z > 360.0f) {
            this.field_70177_z -= 360.0f;
        }
        this.field_70177_z = (float)((double)this.field_70177_z + this.field_70179_y * 14.0);
        this.field_70125_A = (float)((double)this.field_70125_A + -this.field_70159_w * 14.0);
        this.field_70177_z *= 0.9f;
        this.field_70125_A *= 0.9f;
        if (!this.field_70170_p.field_72995_K && !this.hasActivated) {
            BlockPos pos = new BlockPos((Entity)this);
            if (this.field_70170_p.func_180495_p(pos).func_177230_c() == this.getBlockState().func_177230_c()) {
                IPlacementFlagCapability data = (IPlacementFlagCapability)this.field_70170_p.func_175726_f(pos).getCapability(CapabilitiesAether.CHUNK_PLACEMENT_FLAG, EnumFacing.UP);
                if (data != null) {
                    this.allowDoubleDrops = !data.isModified(pos);
                    this.field_70170_p.func_175698_g(pos);
                }
            } else {
                this.func_70106_y();
            }
            this.hasActivated = true;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.field_70170_p.field_72995_K) {
            if (this.holdingPlayer != null) {
                if (this.ticksStuck > 30 || this.func_70011_f(this.holdingPlayer.field_70165_t, this.holdingPlayer.field_70163_u, this.holdingPlayer.field_70161_v) > 6.0) {
                    this.setHoldingPlayer(null);
                }
                this.ticksStuck = this.field_70132_H ? ++this.ticksStuck : 0;
            }
            this.updatePosition();
        }
    }

    public void setHoldingPlayer(EntityPlayer player) {
        this.holdingPlayer = player;
    }

    public void updatePosition() {
        if (this.holdingPlayer == null) {
            ++this.ticksFalling;
            BlockPos pos = new BlockPos((Entity)this);
            if (this.ticksFalling >= 160) {
                this.destroy();
                return;
            }
            this.field_70181_x -= 0.045;
            if (this.field_70122_E) {
                this.field_70159_w += ((double)pos.func_177958_n() - this.field_70165_t + 0.45) * 0.15;
                this.field_70179_y += ((double)pos.func_177952_p() - this.field_70161_v + 0.45) * 0.15;
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                if (state.func_177230_c() != Blocks.field_150350_a && !state.func_185915_l() && !state.func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos)) {
                    this.field_70159_w = -0.15 + this.field_70146_Z.nextDouble() * 0.3;
                    this.field_70181_x = 0.5;
                    this.field_70179_y = -0.15 + this.field_70146_Z.nextDouble() * 0.3;
                }
                double distanceFromCenter = pos.func_177954_c(this.field_70165_t + 0.45, this.field_70163_u, this.field_70161_v + 0.45);
                if (this.field_70181_x + this.field_70159_w + this.field_70179_y <= 0.04 && distanceFromCenter <= 2.0 && !this.field_70170_p.field_72995_K) {
                    IPlacementFlagCapability data;
                    IBlockState replacingState = this.field_70170_p.func_180495_p(pos);
                    if (!replacingState.func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos)) {
                        this.destroy();
                        return;
                    }
                    this.field_70170_p.func_175655_b(pos, true);
                    this.field_70170_p.func_175656_a(pos, this.getBlockState());
                    this.field_70170_p.func_175685_c(pos, this.getBlockState().func_177230_c(), false);
                    if (!this.allowDoubleDrops && (data = (IPlacementFlagCapability)this.field_70170_p.func_175726_f(pos).getCapability(CapabilitiesAether.CHUNK_PLACEMENT_FLAG, EnumFacing.UP)) != null) {
                        data.markModified(pos);
                    }
                    this.func_70106_y();
                    return;
                }
                this.field_70159_w *= 0.8;
                this.field_70179_y *= 0.8;
            } else {
                this.field_70159_w *= 0.95;
                this.field_70179_y *= 0.95;
            }
            this.field_70181_x *= 0.94;
        } else {
            this.ticksFalling = 0;
            Vec3d look = this.holdingPlayer.func_70040_Z();
            float distance = 2.5f;
            double toX = this.holdingPlayer.field_70165_t + look.field_72450_a * 2.5;
            double toY = this.holdingPlayer.field_70163_u + look.field_72448_b * 2.5 + 1.0;
            double toZ = this.holdingPlayer.field_70161_v + look.field_72449_c * 2.5;
            this.field_70159_w *= 0.8;
            this.field_70181_x *= 0.8;
            this.field_70179_y *= 0.8;
            this.field_70159_w += (toX - this.field_70165_t) * 0.1;
            this.field_70181_x += (toY - this.field_70163_u) * 0.1;
            this.field_70179_y += (toZ - this.field_70161_v) * 0.1;
        }
    }

    private void destroy() {
        this.func_70106_y();
        BlockPos pos = new BlockPos((Entity)this);
        IBlockState state = this.getBlockState();
        NonNullList drops = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(drops, (IBlockAccess)this.field_70170_p, pos, state, 0);
        for (ItemStack stack : drops) {
            Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)stack);
        }
    }

    public boolean isFalling() {
        return this.holdingPlayer == null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        Block block = Block.func_149729_e((int)compound.func_74762_e("Block"));
        this.setBlockState(block.func_176203_a((int)compound.func_74771_c("BlockMeta")));
        this.ticksFalling = compound.func_74762_e("TicksFalling");
        this.allowDoubleDrops = compound.func_74767_n("AllowDoubleDrops");
        this.hasActivated = this.field_70173_aa > 1;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        IBlockState state = this.getBlockState();
        Block block = state.func_177230_c();
        compound.func_74768_a("Block", Block.field_149771_c.func_148757_b((Object)block));
        compound.func_74774_a("BlockMeta", (byte)block.func_176201_c(state));
        compound.func_74768_a("TicksFalling", this.ticksFalling);
        compound.func_74757_a("AllowDoubleDrops", this.allowDoubleDrops);
    }

    public IBlockState getBlockState() {
        Block block = Block.func_149729_e((int)((Integer)this.field_70180_af.func_187225_a(BLOCK_NAME)));
        byte meta = (Byte)this.field_70180_af.func_187225_a(BLOCK_METADATA);
        return block.func_176203_a((int)meta);
    }

    public void setBlockState(IBlockState state) {
        Block block = state.func_177230_c();
        this.field_70180_af.func_187227_b(BLOCK_NAME, (Object)Block.field_149771_c.func_148757_b((Object)block));
        this.field_70180_af.func_187227_b(BLOCK_METADATA, (Object)((byte)block.func_176201_c(state)));
    }
}

