/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.animals;

import com.gildedgames.aether.api.entity.damage.DamageTypeAttributes;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffects;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.api.registrar.SoundsAether;
import com.gildedgames.aether.common.blocks.natural.leaves.BlockColoredLeaves;
import com.gildedgames.aether.common.blocks.natural.wood.AetherWoodType;
import com.gildedgames.aether.common.blocks.natural.wood.BlockAetherLog;
import com.gildedgames.aether.common.entities.animals.EntityAetherAnimal;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySkyrootLizard
extends EntityAetherAnimal {
    protected Map<String, Float> defenseMap = Maps.newHashMap();
    private static final DataParameter<Byte> LIZARD_TYPE = EntityDataManager.func_187226_a(EntitySkyrootLizard.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> LIZARD_COLOR = EntityDataManager.func_187226_a(EntitySkyrootLizard.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final Type[] RANDOM_TYPES = new Type[]{Type.AMBERROOT, Type.SKYROOT, Type.WISPROOT, Type.GREATROOT};

    public EntitySkyrootLizard(World world) {
        super(world);
        this.defenseMap.put("Very Weak", Float.valueOf(4.0f));
        this.defenseMap.put("Weak", Float.valueOf(2.0f));
        this.defenseMap.put("Average", Float.valueOf(0.0f));
        this.defenseMap.put("Strong", Float.valueOf(-2.0f));
        this.defenseMap.put("Very Strong", Float.valueOf(-4.0f));
        this.func_70105_a(0.8f, 0.3f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5, 10));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 20.0f, 0.7, 0.85));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
    }

    public void func_70088_a() {
        super.func_70088_a();
        Type type = RANDOM_TYPES[this.field_70146_Z.nextInt(RANDOM_TYPES.length)];
        BlockColoredLeaves.Color color = BlockColoredLeaves.Color.VALUES[this.field_70146_Z.nextInt(BlockColoredLeaves.Color.VALUES.length)];
        this.field_70180_af.func_187214_a(LIZARD_TYPE, (Object)((byte)type.ordinal()));
        this.field_70180_af.func_187214_a(LIZARD_COLOR, (Object)((byte)color.ordinal()));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.7);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111128_a(0.0);
        this.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111128_a(0.0);
        this.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111128_a(4.0);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (distance > 4.0f) {
            IAetherStatusEffects.applyStatusEffect((EntityLivingBase)this, IAetherStatusEffects.effectTypes.STUN, 100);
        }
    }

    public Type getLeafType() {
        byte ordinal = (Byte)this.field_70180_af.func_187225_a(LIZARD_TYPE);
        if (ordinal < 0 || ordinal >= Type.VALUES.length) {
            return Type.SKYROOT;
        }
        return Type.VALUES[ordinal];
    }

    public BlockColoredLeaves.Color getLeafColor() {
        byte ordinal = (Byte)this.field_70180_af.func_187225_a(LIZARD_COLOR);
        if (ordinal < 0 || ordinal > BlockColoredLeaves.Color.VALUES.length) {
            return BlockColoredLeaves.Color.GREEN;
        }
        return BlockColoredLeaves.Color.VALUES[ordinal];
    }

    public void setLizardColor(BlockColoredLeaves.Color color) {
        int ordinal = -1;
        if (color != null) {
            ordinal = color.ordinal();
        }
        this.field_70180_af.func_187227_b(LIZARD_COLOR, (Object)((byte)ordinal));
    }

    public void setLizardType(Type type) {
        this.field_70180_af.func_187227_b(LIZARD_TYPE, (Object)((byte)type.ordinal()));
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        super.func_184645_a(player, hand);
        ItemStack itemStack = player.func_184586_b(hand);
        if (!(itemStack.func_190926_b() || itemStack.func_77973_b() != ItemsAether.skyroot_stick && itemStack.func_77973_b() != Items.field_151055_y)) {
            this.func_175505_a(player, itemStack);
            ItemStack itemStackLizard = new ItemStack(ItemsAether.skyroot_lizard_stick);
            if (!player.field_71071_by.func_70441_a(itemStackLizard)) {
                player.func_71019_a(itemStackLizard, false);
            }
            if (player.func_70613_aW()) {
                player.func_184185_a(SoundsAether.aerbunny_hurt, 1.0f, 0.3f);
            }
            this.field_70170_p.func_72900_e((Entity)this);
            return true;
        }
        return false;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.aerbunny_death;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("type", (int)((Byte)this.field_70180_af.func_187225_a(LIZARD_TYPE)).byteValue());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(LIZARD_TYPE, (Object)((byte)nbt.func_74762_e("type")));
    }

    @SideOnly(value=Side.CLIENT)
    public int getLizardAccentColor() {
        Type type = this.getLeafType();
        if (type == Type.AMBERROOT) {
            return Integer.MIN_VALUE;
        }
        BlockColoredLeaves.Color color = this.getLeafColor();
        if (type == Type.SKYROOT) {
            switch (color) {
                case GREEN: {
                    return 7049559;
                }
                case BLUE: {
                    return 6130586;
                }
                case DARK_BLUE: {
                    return 3886751;
                }
            }
        } else if (type == Type.WISPROOT) {
            switch (color) {
                case GREEN: {
                    return 8561006;
                }
                case BLUE: {
                    return 6656148;
                }
                case DARK_BLUE: {
                    return 6713514;
                }
            }
        } else if (type == Type.GREATROOT) {
            switch (color) {
                case GREEN: {
                    return 5007154;
                }
                case BLUE: {
                    return 4087399;
                }
                case DARK_BLUE: {
                    return 1911389;
                }
            }
        }
        return 0xFFFFFF;
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public static enum Type {
        SKYROOT,
        GREATROOT,
        WISPROOT,
        AMBERROOT;

        public static final Type[] VALUES;

        public static Type getFromWoodType(BlockAetherLog block) {
            AetherWoodType type = block.getAetherWoodType();
            switch (type) {
                case SKYROOT: {
                    return SKYROOT;
                }
                case GREATROOT: {
                    return GREATROOT;
                }
                case WISPROOT: {
                    return WISPROOT;
                }
                case AMBERROOT: {
                    return AMBERROOT;
                }
            }
            return null;
        }

        static {
            VALUES = Type.values();
        }
    }
}

