/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.animals;

import com.gildedgames.aether.api.entity.damage.DamageTypeAttributes;
import com.gildedgames.aether.api.entity.damage.IDefenseLevelsHolder;
import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.SoundsAether;
import com.gildedgames.aether.common.entities.ai.EntityAIHideFromRain;
import com.gildedgames.aether.common.entities.ai.EntityAIRestrictRain;
import com.gildedgames.aether.common.entities.ai.EntityAIUnstuckBlueAercloud;
import com.gildedgames.aether.common.entities.ai.kirrid.EntityAIEatAetherGrass;
import com.gildedgames.aether.common.entities.multipart.AetherMultiPartShearable;
import com.gildedgames.aether.common.init.LootTablesAether;
import com.gildedgames.aether.common.util.helpers.MathUtil;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Point3d;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntitySheepuff
extends EntitySheep
implements IEntityMultiPart,
IDefenseLevelsHolder {
    protected Map<String, Float> defenseMap = Maps.newHashMap();
    public static final DataParameter<Float> PUFFINESS = EntityDataManager.func_187226_a(EntitySheepuff.class, (DataSerializer)DataSerializers.field_187193_c);
    private float offGroundCheck;
    protected EntityAIEatAetherGrass field_146087_bs;
    private final Point3d old;
    private final MultiPartEntityPart[] parts;
    private final MultiPartEntityPart head;

    public EntitySheepuff(World worldIn) {
        super(worldIn);
        this.defenseMap.put("Very Weak", Float.valueOf(4.0f));
        this.defenseMap.put("Weak", Float.valueOf(2.0f));
        this.defenseMap.put("Average", Float.valueOf(0.0f));
        this.defenseMap.put("Strong", Float.valueOf(-2.0f));
        this.defenseMap.put("Very Strong", Float.valueOf(-4.0f));
        this.head = new AetherMultiPartShearable(this, "head", 0.6f, 0.6f);
        this.parts = new MultiPartEntityPart[]{this.head};
        this.old = new Point3d();
        this.func_70105_a(1.1f, 1.4f);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_146087_bs = new EntityAIEatAetherGrass((EntityLiving)this, 350);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictRain((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIUnstuckBlueAercloud((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIHideFromRain((EntityCreature)this, 1.3));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)this.field_146087_bs);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PUFFINESS, (Object)Float.valueOf(0.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111128_a(0.0);
        this.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111128_a(-2.0);
        this.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111128_a(2.0);
    }

    public EntitySheepuff createChild(EntityAgeable ageable) {
        return new EntitySheepuff(this.field_70170_p);
    }

    public World func_82194_d() {
        return this.func_130014_f_();
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        if (this.field_70172_ad <= 10) {
            return this.func_70097_a(source, damage * 1.1f);
        }
        return false;
    }

    @Nullable
    public MultiPartEntityPart[] getParts() {
        return this.parts;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean result = super.func_70097_a(source, amount);
        if (result && this.field_70122_E && !this.func_70892_o()) {
            this.field_70181_x = 1.5f + this.field_70146_Z.nextFloat();
        }
        return result;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.old.set(this.head.field_70165_t, this.head.field_70163_u, this.head.field_70161_v);
        float f = MathUtil.interpolateRotation(this.field_70760_ar, this.field_70761_aq, 1.0f);
        float f1 = MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180) - (float)Math.PI));
        this.head.func_70012_b(this.field_70165_t - (double)(f2 * 0.8f), this.field_70163_u + (double)0.85f, this.field_70161_v - (double)(f1 * 0.8f), 0.0f, 0.0f);
        this.head.func_70071_h_();
        this.head.field_70169_q = this.old.getX();
        this.head.field_70167_r = this.old.getY();
        this.head.field_70166_s = this.old.getZ();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70181_x < -0.1 && !this.func_70892_o()) {
            this.field_70181_x = -0.1;
            this.field_70143_R = 0.0f;
        }
        if (!this.field_70122_E) {
            this.offGroundCheck = (float)((double)this.offGroundCheck + Math.abs(this.field_70181_x));
            if (this.offGroundCheck > 2.0f) {
                this.addPuffiness(0.1f);
            }
        } else {
            this.offGroundCheck = 0.0f;
            this.addPuffiness(-0.05f);
        }
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.field_70181_x = 0.0;
        this.func_70893_e(true);
        int count = 1 + this.field_70146_Z.nextInt(3);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < count; ++i) {
            ret.add(new ItemStack(BlocksAether.cloudwool_block));
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_175512_b(EnumDyeColor.WHITE);
        return livingdata;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.55f;
    }

    protected SoundEvent func_184639_G() {
        return SoundsAether.kirrid_ambient;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsAether.kirrid_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.kirrid_death;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.func_70892_o()) {
            return LootTablesAether.ENTITY_KIRRID_SHEARED;
        }
        return LootTablesAether.ENTITY_KIRRID;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.func_70892_o()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    public void func_70615_aA() {
        super.func_70615_aA();
        this.field_70181_x = 1.5f + this.field_70146_Z.nextFloat();
    }

    public void addPuffiness(float puffiness) {
        this.field_70180_af.func_187227_b(PUFFINESS, (Object)Float.valueOf(MathHelper.func_76131_a((float)(this.getPuffiness() + puffiness), (float)0.0f, (float)1.0f)));
    }

    public float getPuffiness() {
        return ((Float)this.field_70180_af.func_187225_a(PUFFINESS)).floatValue();
    }
}

