/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.animals;

import com.gildedgames.aether.api.entity.IEntityEyesComponent;
import com.gildedgames.aether.api.entity.IMount;
import com.gildedgames.aether.api.entity.IMountProcessor;
import com.gildedgames.aether.api.entity.damage.DamageTypeAttributes;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.api.registrar.SoundsAether;
import com.gildedgames.aether.common.entities.ai.AetherNavigateGround;
import com.gildedgames.aether.common.entities.ai.EntityAIUnstuckBlueAercloud;
import com.gildedgames.aether.common.entities.ai.moa.AIAnimalPack;
import com.gildedgames.aether.common.entities.ai.moa.AIAvoidEntityAsChild;
import com.gildedgames.aether.common.entities.ai.moa.AIMoaPackBreeding;
import com.gildedgames.aether.common.entities.ai.moa.AIPanicPack;
import com.gildedgames.aether.common.entities.ai.moa.AIProtectPack;
import com.gildedgames.aether.common.entities.ai.moa.AIStayNearNest;
import com.gildedgames.aether.common.entities.genes.AnimalGender;
import com.gildedgames.aether.common.entities.genes.EntityGeneStorage;
import com.gildedgames.aether.common.entities.genes.EntityGeneticAnimal;
import com.gildedgames.aether.common.entities.genes.GeneUtil;
import com.gildedgames.aether.common.entities.genes.moa.MoaGenePool;
import com.gildedgames.aether.common.entities.genes.moa.MoaNest;
import com.gildedgames.aether.common.entities.mounts.FlyingMount;
import com.gildedgames.aether.common.entities.mounts.IFlyingMountData;
import com.gildedgames.aether.common.entities.multipart.AetherMultiPartEntity;
import com.gildedgames.aether.common.entities.multipart.AetherMultiPartMount;
import com.gildedgames.aether.common.entities.util.eyes.EntityEyesComponent;
import com.gildedgames.aether.common.entities.util.eyes.IEntityEyesComponentProvider;
import com.gildedgames.aether.common.entities.util.groups.EntityGroup;
import com.gildedgames.aether.common.entities.util.groups.EntityGroupMember;
import com.gildedgames.aether.common.items.other.ItemMoaEgg;
import com.gildedgames.aether.common.items.other.ItemMoaFeather;
import com.gildedgames.aether.common.items.other.ItemMoaFeed;
import com.gildedgames.aether.common.util.helpers.MathUtil;
import com.gildedgames.orbis.lib.client.PartialTicks;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.vecmath.Point3d;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityMoa
extends EntityGeneticAnimal<MoaGenePool>
implements EntityGroupMember,
IMount,
IFlyingMountData,
IEntityMultiPart,
IEntityEyesComponentProvider {
    protected Map<String, Float> defenseMap = Maps.newHashMap();
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{ItemsAether.blueberries, ItemsAether.skyroot_lizard_stick});
    private static final DataParameter<Integer> REMAINING_JUMPS = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> EGG_STOLEN = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RAISED_BY_PLAYER = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> AIRBORNE_TIME = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> FOOD_REQUIRED = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FOOD_EATEN = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_HUNGRY = EntityDataManager.func_187226_a(EntityMoa.class, (DataSerializer)DataSerializers.field_187198_h);
    private final IMountProcessor mountProcessor;
    private final MultiPartEntityPart[] parts;
    private final Point3d[] old;
    private final AetherMultiPartEntity neck;
    private final AetherMultiPartEntity head;
    private final AetherMultiPartEntity beak;
    private final AetherMultiPartEntity body;
    private final AetherMultiPartEntity tail;
    private final IEntityEyesComponent eyes;
    public float wingRotation;
    public float destPos;
    public float prevDestPos;
    public float prevWingRotation;
    public int ticksUntilFlap;
    private int hungryTimer;
    private int dropFeatherTimer;
    private int timeUntilDropFeather;
    private float ageSinceOffGround;
    private boolean wasOnGround;
    private boolean isFastFalling;
    private EntityGroup pack;
    private MoaNest familyNest;

    public EntityMoa(World world) {
        super(world);
        this.defenseMap.put("Very Weak", Float.valueOf(4.0f));
        this.defenseMap.put("Weak", Float.valueOf(2.0f));
        this.defenseMap.put("Average", Float.valueOf(0.0f));
        this.defenseMap.put("Strong", Float.valueOf(-2.0f));
        this.defenseMap.put("Very Strong", Float.valueOf(-4.0f));
        this.mountProcessor = new FlyingMount(this);
        this.neck = new AetherMultiPartMount(this, "neck", 0.4f, 0.8f);
        this.head = new AetherMultiPartMount(this, "head", 0.8f, 0.6f);
        this.beak = new AetherMultiPartMount(this, "beak", 0.4f, 0.5f);
        this.body = new AetherMultiPartMount(this, "body", 1.1f, 1.325f);
        this.tail = new AetherMultiPartMount(this, "tail", 1.1f, 0.6f);
        this.eyes = new EntityEyesComponent((EntityLivingBase)this);
        this.wasOnGround = true;
        this.isFastFalling = false;
        this.initAI();
        this.familyNest = new MoaNest(world);
        this.func_70105_a(1.0f, 2.0f);
        this.field_70138_W = 1.0f;
        this.parts = new MultiPartEntityPart[]{this.head, this.neck, this.beak, this.body, this.tail};
        this.old = new Point3d[this.parts.length];
        for (int i = 0; i < this.old.length; ++i) {
            this.old[i] = new Point3d();
        }
    }

    public EntityMoa(World world, int geneticSeed) {
        this(world);
        ((MoaGenePool)this.getGenePool()).transformFromSeed(geneticSeed);
    }

    public EntityMoa(World world, MoaNest familyNest) {
        this(world, familyNest.familyGeneticSeed);
        this.familyNest = familyNest;
        this.initAI();
    }

    public EntityMoa(World world, MoaNest familyNest, int fatherSeed, int motherSeed) {
        this(world, familyNest);
        if (fatherSeed == motherSeed) {
            ((MoaGenePool)this.getGenePool()).transformFromSeed(fatherSeed);
        } else {
            ((MoaGenePool)this.getGenePool()).transformFromParents(GeneUtil.getRandomSeed(world), fatherSeed, motherSeed);
        }
    }

    public float getAgeSinceOffGround() {
        return this.ageSinceOffGround;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new AetherNavigateGround((EntityLiving)this, worldIn);
    }

    private void initAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIMoaPackBreeding(this, 0.25f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPanicPack((EntityCreature)this, 0.55f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIUnstuckBlueAercloud((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIAnimalPack((EntityLiving)this, 0.55f));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new AIAvoidEntityAsChild((EntityCreature)this, EntityPlayer.class, 5.0f, 0.3, 0.3));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.7, true));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new AIStayNearNest(this, 8, 0.55f));
        this.field_70714_bg.func_75776_a(16, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIProtectPack((EntityCreature)this));
    }

    @Override
    public MoaGenePool createNewGenePool() {
        return new MoaGenePool(new EntityGeneStorage(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111128_a(0.0);
        this.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111128_a(2.0);
        this.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111128_a(-2.0);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(REMAINING_JUMPS, (Object)0);
        this.field_70180_af.func_187214_a(EGG_STOLEN, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(RAISED_BY_PLAYER, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(GENDER, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(AIRBORNE_TIME, (Object)Float.valueOf(this.maxAirborneTime()));
        this.field_70180_af.func_187214_a(FOOD_REQUIRED, (Object)0);
        this.field_70180_af.func_187214_a(FOOD_EATEN, (Object)0);
        this.field_70180_af.func_187214_a(IS_HUNGRY, (Object)false);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemMoaFeed moaFeed;
        float healAmount;
        if (!this.isRaisedByPlayer()) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ItemMoaFeed && (healAmount = (float)(moaFeed = (ItemMoaFeed)stack.func_77973_b()).getHealingAmount()) != 0.0f && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(healAmount);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        if (this.func_70631_g_()) {
            if (this.isHungry() && (stack.func_77973_b() == ItemsAether.aechor_petal || stack.func_77973_b() == ItemsAether.skyroot_lizard_stick)) {
                this.setIsHungry(false);
                this.func_70606_j(this.func_110138_aP());
                this.setFoodEaten(this.getFoodEaten() + 1);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
        } else {
            if (!this.isSaddled() && stack.func_77973_b() == ItemsAether.aether_saddle) {
                this.setIsSaddled(true);
                this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
            return super.func_184645_a(player, hand);
        }
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.eyes.update();
        if (this.field_70703_bu) {
            this.field_70181_x += (double)0.05f;
        }
        if (this.pack == null) {
            this.pack = this.familyNest.getAnimalPack();
        }
        this.updateWingRotation();
        this.fallSlowly();
        if (!this.field_70170_p.field_72995_K) {
            ++this.dropFeatherTimer;
            if (this.timeUntilDropFeather == 0) {
                this.timeUntilDropFeather = (120 + this.func_70681_au().nextInt(80)) * 20;
            }
            if (this.dropFeatherTimer >= this.timeUntilDropFeather) {
                this.timeUntilDropFeather = 0;
                ItemStack feather = new ItemStack(ItemsAether.moa_feather);
                ItemMoaFeather.setColor(feather, ((MoaGenePool)this.getGenePool()).getFeathers().gene().unlocalizedName(), ((MoaGenePool)this.getGenePool()).getFeathers().gene().data().getRGB());
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)feather);
                this.dropFeatherTimer = 0;
            }
            if (this.func_70631_g_() && this.isRaisedByPlayer()) {
                if (this.getFoodEaten() >= this.getFoodRequired()) {
                    this.func_70873_a(-1);
                }
                ++this.hungryTimer;
                if (this.isHungry()) {
                    if (this.hungryTimer > 2400 && this.hungryTimer % 200 == 0) {
                        this.func_70097_a(DamageSource.field_76366_f, 1.0f);
                    }
                } else if (this.hungryTimer > 2400) {
                    this.setIsHungry(true);
                }
            }
        }
    }

    private void fallSlowly() {
        boolean riderSneaking;
        this.field_70143_R = 0.0f;
        boolean bl = riderSneaking = !this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) != null && ((Entity)this.func_184188_bt().get(0)).func_70093_af();
        if (!this.field_70122_E) {
            if (riderSneaking) {
                this.isFastFalling = true;
            } else if (this.field_70181_x < 0.0) {
                this.field_70181_x *= 0.6375;
            }
        }
        if (!riderSneaking) {
            this.isFastFalling = false;
        }
    }

    @Override
    public boolean isFastFalling() {
        return this.isFastFalling;
    }

    public void updateWingRotation() {
        if (!this.field_70122_E) {
            if (this.wasOnGround) {
                this.ageSinceOffGround = (float)this.field_70173_aa + PartialTicks.get();
                this.wasOnGround = false;
            }
            if (this.ticksUntilFlap == 0) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsAether.generic_wing_flap, SoundCategory.NEUTRAL, 0.4f, 0.8f + this.func_70681_au().nextFloat() * 0.6f, false);
                this.ticksUntilFlap = 11;
            } else {
                --this.ticksUntilFlap;
            }
        } else if (this.field_70170_p.field_72995_K && !this.wasOnGround) {
            this.ageSinceOffGround = (float)this.field_70173_aa + PartialTicks.get();
            this.wasOnGround = true;
        }
        this.prevWingRotation = this.wingRotation;
        this.prevDestPos = this.destPos;
        this.destPos = (float)((double)this.destPos + 0.2);
        this.destPos = Math.min(1.0f, Math.max(0.01f, this.destPos));
        if (this.field_70122_E) {
            this.destPos = 0.0f;
        }
        this.wingRotation += 0.533f;
    }

    public boolean func_70652_k(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_71075_bZ.field_75098_d) {
                return super.func_70652_k(entity);
            }
        }
        entity.field_70181_x = 0.8f;
        entity.field_70179_y = this.func_70040_Z().field_72449_c;
        entity.field_70159_w = this.func_70040_Z().field_72450_a;
        entity.field_70133_I = true;
        entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.isGroupLeader() ? 3.0f : 2.0f);
        return super.func_70652_k(entity);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("playerGrown", this.isRaisedByPlayer());
        if (this.getGender() != null) {
            nbt.func_74778_a("creatureGender", this.getGender().name());
        }
        nbt.func_74768_a("remainingJumps", this.getRemainingJumps());
        this.familyNest.writeToNBT(nbt);
        nbt.func_74757_a("isSaddled", this.isSaddled());
        nbt.func_74757_a("isHungry", this.isHungry());
        nbt.func_74768_a("foodRequired", this.getFoodRequired());
        nbt.func_74768_a("foodEaten", this.getFoodEaten());
        nbt.func_74768_a("hungryTimer", this.hungryTimer);
        nbt.func_74768_a("dropFeatherTimer", this.dropFeatherTimer);
        nbt.func_74768_a("timeUntilDropFeather", this.timeUntilDropFeather);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setRaisedByPlayer(nbt.func_74767_n("playerGrown"));
        if (nbt.func_74764_b("creatureGender")) {
            this.setGender(AnimalGender.get(nbt.func_74779_i("creatureGender")));
        }
        this.setRemainingJumps(nbt.func_74762_e("remainingJumps"));
        this.familyNest.readFromNBT(nbt);
        this.setIsSaddled(nbt.func_74767_n("isSaddled"));
        this.setIsHungry(nbt.func_74767_n("isHungry"));
        this.setFoodRequired(nbt.func_74762_e("foodRequired"));
        this.setFoodEaten(nbt.func_74762_e("foodEaten"));
        this.hungryTimer = nbt.func_74762_e("hungryTimer");
        this.dropFeatherTimer = nbt.func_74762_e("dropFeatherTimer");
        this.timeUntilDropFeather = nbt.func_74762_e("timeUntilDropFeather");
    }

    protected void func_70628_a(boolean p_70628_1_, int looting) {
        super.func_70628_a(p_70628_1_, looting);
        ItemStack feather = new ItemStack(ItemsAether.moa_feather, this.func_70681_au().nextInt(3));
        ItemMoaFeather.setColor(feather, ((MoaGenePool)this.getGenePool()).getFeathers().gene().unlocalizedName(), ((MoaGenePool)this.getGenePool()).getFeathers().gene().data().getRGB());
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)feather);
        if (this.isSaddled()) {
            this.func_145779_a(ItemsAether.aether_saddle, 1);
        }
    }

    @Override
    public boolean isGroupLeader() {
        return this.getGender() == AnimalGender.MALE;
    }

    @Override
    public EntityGroup getGroup() {
        return this.familyNest != null ? this.familyNest.getAnimalPack() : null;
    }

    @Override
    public boolean isProtective() {
        return this.isGroupLeader() || this.hasEggBeenStolen();
    }

    public boolean hasEggBeenStolen() {
        return (Boolean)this.field_70180_af.func_187225_a(EGG_STOLEN);
    }

    public void setEggStolen(boolean flag) {
        this.field_70180_af.func_187227_b(EGG_STOLEN, (Object)flag);
    }

    public boolean isRaisedByPlayer() {
        return (Boolean)this.field_70180_af.func_187225_a(RAISED_BY_PLAYER);
    }

    public void setRaisedByPlayer(boolean flag) {
        this.field_70180_af.func_187227_b(RAISED_BY_PLAYER, (Object)flag);
    }

    public AnimalGender getGender() {
        return (Boolean)this.field_70180_af.func_187225_a(GENDER) != false ? AnimalGender.MALE : AnimalGender.FEMALE;
    }

    public void setGender(AnimalGender gender) {
        this.field_70180_af.func_187227_b(GENDER, (Object)(gender == AnimalGender.MALE ? 1 : 0));
        this.updateMultiPart();
    }

    public int getRemainingJumps() {
        return (Integer)this.field_70180_af.func_187225_a(REMAINING_JUMPS);
    }

    private void setRemainingJumps(int jumps) {
        this.field_70180_af.func_187227_b(REMAINING_JUMPS, (Object)jumps);
    }

    public int getFoodEaten() {
        return (Integer)this.field_70180_af.func_187225_a(FOOD_EATEN);
    }

    public void setFoodEaten(int foodEaten) {
        this.field_70180_af.func_187227_b(FOOD_EATEN, (Object)foodEaten);
    }

    public int getFoodRequired() {
        return (Integer)this.field_70180_af.func_187225_a(FOOD_REQUIRED);
    }

    public void setFoodRequired(int foodRequired) {
        this.field_70180_af.func_187227_b(FOOD_REQUIRED, (Object)foodRequired);
    }

    public boolean isHungry() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_HUNGRY);
    }

    public void setIsHungry(boolean flag) {
        if ((Boolean)this.field_70180_af.func_187225_a(IS_HUNGRY) != flag) {
            this.hungryTimer = 0;
        }
        this.field_70180_af.func_187227_b(IS_HUNGRY, (Object)flag);
    }

    public MoaNest getFamilyNest() {
        return this.familyNest;
    }

    public EntityGroup getAnimalPack() {
        return this.pack;
    }

    public void setAnimalPack(EntityGroup pack) {
        this.pack = pack;
        this.pack.onAnimalJoin(this);
    }

    public void func_70645_a(DamageSource damageSource) {
        if (this.pack != null) {
            this.pack.onAnimalDeath(this);
        }
        super.func_70645_a(damageSource);
    }

    public void func_70604_c(EntityLivingBase entity) {
        super.func_70604_c(entity);
        if (this.pack != null && entity != null) {
            if (this.isRaisedByPlayer()) {
                return;
            }
            this.pack.addOrRenewAggressor(entity);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.setMultiPartLocations();
    }

    public float getSize() {
        return (this.func_70631_g_() ? 0.65f : 1.0f) + (this.isGroupLeader() ? 0.15f : 0.0f);
    }

    protected void func_175500_n() {
        this.updateMultiPart();
    }

    private void updateMultiPart() {
        float scale = this.getSize();
        this.neck.updateSize(0.4f * scale, 0.8f * scale);
        this.head.updateSize(0.8f * scale, 0.6f * scale);
        this.beak.updateSize(0.4f * scale, 0.5f * scale);
        this.body.updateSize(1.1f * scale, 1.325f * scale);
        this.tail.updateSize(1.1f * scale, 0.6f * scale);
    }

    private void setMultiPartLocations() {
        float scale = this.getSize();
        for (int i = 0; i < this.parts.length; ++i) {
            this.old[i].set(this.parts[i].field_70165_t, this.parts[i].field_70163_u, this.parts[i].field_70161_v);
        }
        this.updateMultiPart();
        float f = MathUtil.interpolateRotation(this.field_70760_ar, this.field_70761_aq, 1.0f);
        float f1 = MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180) - (float)Math.PI)) * scale;
        float f2 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180) - (float)Math.PI)) * scale;
        this.head.func_70071_h_();
        this.head.func_70012_b(this.field_70165_t - (double)(f2 * 0.5f), this.field_70163_u + (double)(1.45f * scale), this.field_70161_v - (double)(f1 * 0.5f), 0.0f, 0.0f);
        this.beak.func_70071_h_();
        this.beak.func_70012_b(this.field_70165_t - (double)(f2 * 1.1f), this.field_70163_u + (double)(1.5f * scale), this.field_70161_v - (double)(f1 * 1.1f), 0.0f, 0.0f);
        this.neck.func_70071_h_();
        this.neck.func_70012_b(this.field_70165_t - (double)(f2 * 0.6f), this.field_70163_u + (double)(0.75f * scale), this.field_70161_v - (double)(f1 * 0.6f), 0.0f, 0.0f);
        this.tail.func_70071_h_();
        this.tail.func_70012_b(this.field_70165_t + (double)(f2 * 1.1f), this.field_70163_u + (double)(0.5f * scale), this.field_70161_v + (double)(f1 * 1.1f), 0.0f, 0.0f);
        this.body.func_70071_h_();
        this.body.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].field_70169_q = this.old[i].getX();
            this.parts[i].field_70167_r = this.old[i].getY();
            this.parts[i].field_70166_s = this.old[i].getZ();
        }
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        switch (part.field_146032_b) {
            case "head": {
                damage *= 1.3f;
                break;
            }
            case "beak": {
                damage *= 1.1f;
                break;
            }
            case "tail": {
                damage *= 0.2f;
            }
        }
        if (this.field_70172_ad <= 10) {
            return this.func_70097_a(source, damage);
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        return (!this.func_184207_aI() || entity == null || !this.func_184215_y(entity)) && super.func_70097_a(source, amount);
    }

    public World func_82194_d() {
        return this.func_130014_f_();
    }

    public boolean func_70067_L() {
        return false;
    }

    @Nullable
    public MultiPartEntityPart[] getParts() {
        return this.parts;
    }

    public EntityAgeable func_90011_a(EntityAgeable matingAnimal) {
        return new EntityMoa(this.field_70170_p);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack moaEgg = new ItemStack(ItemsAether.moa_egg_item);
        MoaGenePool stackGenes = ItemMoaEgg.getGenePool(moaEgg);
        stackGenes.transformFromParents(((MoaGenePool)this.getGenePool()).getStorage().getSeed(), ((MoaGenePool)this.getGenePool()).getStorage().getFatherSeed(), ((MoaGenePool)this.getGenePool()).getStorage().getMotherSeed());
        ItemMoaEgg.setGenePool(moaEgg, stackGenes);
        return moaEgg;
    }

    protected SoundEvent func_184639_G() {
        return SoundsAether.moa_ambient;
    }

    protected SoundEvent func_184601_bQ(DamageSource src) {
        return SoundsAether.moa_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.moa_hurt;
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public void setIsSaddled(boolean isSaddled) {
        this.field_70180_af.func_187227_b(SADDLED, (Object)isSaddled);
    }

    @Override
    public IMountProcessor getMountProcessor() {
        return this.mountProcessor;
    }

    @Override
    public void resetRemainingAirborneTime() {
        this.field_70180_af.func_187227_b(AIRBORNE_TIME, (Object)Float.valueOf(this.maxAirborneTime()));
    }

    @Override
    public float getRemainingAirborneTime() {
        return ((Float)this.field_70180_af.func_187225_a(AIRBORNE_TIME)).floatValue();
    }

    @Override
    public void setRemainingAirborneTime(float set) {
        this.field_70180_af.func_187227_b(AIRBORNE_TIME, (Object)Float.valueOf(set));
    }

    @Override
    public void addRemainingAirborneTime(float add) {
        this.setRemainingAirborneTime(this.getRemainingAirborneTime() + add);
    }

    @Override
    public boolean canBeMounted() {
        return this.isSaddled();
    }

    @Override
    public boolean canProcessMountInteraction(EntityPlayer rider, ItemStack stack) {
        return !this.func_70877_b(stack) && !(stack.func_77973_b() instanceof ItemMoaFeed) && (stack == null || stack.func_77973_b() != Items.field_151058_ca);
    }

    public double func_70042_X() {
        return this.getGender() == AnimalGender.MALE ? 1.15 : (double)0.9f;
    }

    public float maxAirborneTime() {
        return 20.0f;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    @Override
    public IEntityEyesComponent getEyes() {
        return this.eyes;
    }
}

