/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.animals;

import com.gildedgames.aether.api.entity.IEntityEyesComponent;
import com.gildedgames.aether.api.entity.damage.DamageTypeAttributes;
import com.gildedgames.aether.api.entity.damage.IDefenseLevelsHolder;
import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.api.registrar.SoundsAether;
import com.gildedgames.aether.common.entities.ai.AetherNavigateGround;
import com.gildedgames.aether.common.entities.ai.EntityAIHideFromRain;
import com.gildedgames.aether.common.entities.ai.EntityAIRestrictRain;
import com.gildedgames.aether.common.entities.ai.EntityAIUnstuckBlueAercloud;
import com.gildedgames.aether.common.entities.ai.kirrid.EntityAIEatAetherGrass;
import com.gildedgames.aether.common.entities.multipart.AetherMultiPartShearable;
import com.gildedgames.aether.common.entities.util.eyes.EntityEyesComponent;
import com.gildedgames.aether.common.entities.util.eyes.IEntityEyesComponentProvider;
import com.gildedgames.aether.common.init.LootTablesAether;
import com.gildedgames.aether.common.util.helpers.MathUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.vecmath.Point3d;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityKirrid
extends EntitySheep
implements IEntityMultiPart,
IEntityEyesComponentProvider,
IDefenseLevelsHolder {
    protected Map<String, Float> defenseMap = Maps.newHashMap();
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{ItemsAether.valkyrie_wings});
    private final Point3d[] old;
    private final MultiPartEntityPart[] parts;
    private final MultiPartEntityPart head;
    private final MultiPartEntityPart back;
    private final IEntityEyesComponent eyes;
    protected EntityAIEatAetherGrass field_146087_bs;
    private int kirridTimer;

    public EntityKirrid(World world) {
        super(world);
        this.defenseMap.put("Very Weak", Float.valueOf(4.0f));
        this.defenseMap.put("Weak", Float.valueOf(2.0f));
        this.defenseMap.put("Average", Float.valueOf(0.0f));
        this.defenseMap.put("Strong", Float.valueOf(-2.0f));
        this.defenseMap.put("Very Strong", Float.valueOf(-4.0f));
        this.head = new AetherMultiPartShearable(this, "head", 0.7f, 0.8f);
        this.back = new AetherMultiPartShearable(this, "back", 0.8f, 1.5f);
        this.eyes = new EntityEyesComponent((EntityLivingBase)this);
        this.func_70105_a(1.0f, 1.5f);
        this.field_175506_bl = BlocksAether.aether_grass;
        this.parts = new MultiPartEntityPart[]{this.head, this.back};
        this.old = new Point3d[this.parts.length];
        for (int i = 0; i < this.old.length; ++i) {
            this.old[i] = new Point3d();
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_146087_bs = new EntityAIEatAetherGrass((EntityLiving)this, this.getEatChance());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictRain((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIUnstuckBlueAercloud((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIHideFromRain((EntityCreature)this, 1.3));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)this.field_146087_bs);
    }

    protected void func_70619_bc() {
        this.kirridTimer = this.field_146087_bs.getTimer();
        super.func_70619_bc();
    }

    public World func_82194_d() {
        return this.func_130014_f_();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.kirridTimer = Math.max(0, this.kirridTimer - 1);
        }
        super.func_70636_d();
        this.eyes.update();
        for (int i = 0; i < this.parts.length; ++i) {
            this.old[i].set(this.parts[i].field_70165_t, this.parts[i].field_70163_u, this.parts[i].field_70161_v);
        }
        float f = MathUtil.interpolateRotation(this.field_70760_ar, this.field_70761_aq, 1.0f);
        float f1 = MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180) - (float)Math.PI));
        this.head.func_70012_b(this.field_70165_t - (double)(f2 * 0.9f), this.field_70163_u + 0.75, this.field_70161_v - (double)(f1 * 0.9f), 0.0f, 0.0f);
        this.head.func_70071_h_();
        this.back.func_70012_b(this.field_70165_t + (double)(f2 * 0.8f), this.field_70163_u, this.field_70161_v + (double)(f1 * 0.8f), 0.0f, 0.0f);
        this.back.func_70071_h_();
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].field_70169_q = this.old[i].getX();
            this.parts[i].field_70167_r = this.old[i].getY();
            this.parts[i].field_70166_s = this.old[i].getZ();
        }
    }

    public int getEatChance() {
        return 1000;
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        if (this.field_70172_ad <= 10) {
            return this.func_70097_a(source, damage * 1.1f);
        }
        return false;
    }

    @Nullable
    public MultiPartEntityPart[] getParts() {
        return this.parts;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new AetherNavigateGround((EntityLiving)this, worldIn);
    }

    public float func_180484_a(BlockPos pos) {
        return super.func_180484_a(pos);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111128_a(0.0);
        this.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111128_a(-2.0);
        this.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111128_a(2.0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_175512_b(EnumDyeColor.WHITE);
        return livingdata;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.55f;
    }

    protected SoundEvent func_184639_G() {
        return SoundsAether.kirrid_ambient;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsAether.kirrid_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.kirrid_death;
    }

    public EntityKirrid createChild(EntityAgeable ageable) {
        return new EntityKirrid(this.field_70170_p);
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.func_70892_o()) {
            return LootTablesAether.ENTITY_KIRRID_SHEARED;
        }
        return LootTablesAether.ENTITY_KIRRID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.kirridTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.func_70893_e(true);
        int count = 1 + this.field_70146_Z.nextInt(3);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < count; ++i) {
            ret.add(new ItemStack(BlocksAether.cloudwool_block));
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70894_j(float p_70894_1_) {
        if (this.kirridTimer <= 0) {
            return 0.0f;
        }
        if (this.kirridTimer >= 4 && this.kirridTimer <= 36) {
            return 1.0f;
        }
        return this.kirridTimer < 4 ? ((float)this.kirridTimer - p_70894_1_) / 4.0f : -((float)(this.kirridTimer - 40) - p_70894_1_) / 4.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70890_k(float p_70890_1_) {
        if (this.kirridTimer > 4 && this.kirridTimer <= 36) {
            float f = ((float)(this.kirridTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.kirridTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @Override
    public IEntityEyesComponent getEyes() {
        return this.eyes;
    }
}

