/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.animals;

import com.gildedgames.aether.api.entity.damage.DamageTypeAttributes;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffects;
import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.api.registrar.SoundsAether;
import com.gildedgames.aether.common.entities.ai.EntityAIHideFromTarget;
import com.gildedgames.aether.common.entities.ai.EntityAIWanderFavorBlocks;
import com.gildedgames.aether.common.entities.ai.glactrix.GlactrixAIHideFromEntity;
import com.gildedgames.aether.common.entities.animals.EntityAetherAnimal;
import com.gildedgames.aether.common.init.LootTablesAether;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class EntityGlactrix
extends EntityAetherAnimal
implements IShearable {
    protected Map<String, Float> defenseMap = Maps.newHashMap();
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{ItemsAether.wyndberry});
    private ArrayList<Block> favoriteBlocks;
    private EntityAIWanderFavorBlocks wanderAI;
    private EntityAIHideFromTarget runeAndHideAI;
    private GlactrixAIHideFromEntity glactrixHideAI;
    private final int wanderAIPriority = 5;
    private final int hideAIPriority = 1;
    private boolean isHiding;
    private boolean isToppled;
    private boolean isSheared;
    private static final DataParameter<Boolean> IS_HIDING = EntityDataManager.func_187226_a(EntityGlactrix.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_TOPPLED = EntityDataManager.func_187226_a(EntityGlactrix.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SHEARED = EntityDataManager.func_187226_a(EntityGlactrix.class, (DataSerializer)DataSerializers.field_187198_h);
    private int timer;
    private final int timerLimit = 2400;

    public EntityGlactrix(World world) {
        super(world);
        this.defenseMap.put("Very Weak", Float.valueOf(4.0f));
        this.defenseMap.put("Weak", Float.valueOf(2.0f));
        this.defenseMap.put("Average", Float.valueOf(0.0f));
        this.defenseMap.put("Strong", Float.valueOf(-2.0f));
        this.defenseMap.put("Very Strong", Float.valueOf(-4.0f));
        this.favoriteBlocks = new ArrayList();
        this.wanderAI = new EntityAIWanderFavorBlocks((EntityCreature)this, 0.3, this.favoriteBlocks);
        this.runeAndHideAI = new EntityAIHideFromTarget((EntityCreature)this, EntityPlayer.class, 0.8);
        this.glactrixHideAI = new GlactrixAIHideFromEntity(this, EntityPlayer.class);
        this.wanderAIPriority = 5;
        this.hideAIPriority = 1;
        this.isHiding = false;
        this.isToppled = false;
        this.isSheared = false;
        this.timerLimit = 2400;
        this.func_70105_a(0.65f, 0.5f);
        this.favoriteBlocks.add(BlocksAether.highlands_packed_ice);
        this.favoriteBlocks.add(BlocksAether.highlands_ice);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_HIDING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(IS_TOPPLED, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(IS_SHEARED, (Object)Boolean.FALSE);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111128_a(-2.0);
        this.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111128_a(-2.0);
        this.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111128_a(2.0);
    }

    public void setHiding(boolean isHiding) {
        this.isHiding = isHiding;
        this.field_70180_af.func_187227_b(IS_HIDING, (Object)isHiding);
    }

    public void setToppled(boolean isToppled) {
        this.isToppled = isToppled;
        this.field_70180_af.func_187227_b(IS_TOPPLED, (Object)isToppled);
    }

    public void setSheared(boolean isSheared) {
        this.isSheared = isSheared;
        this.field_70180_af.func_187227_b(IS_SHEARED, (Object)isSheared);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.getIsSheared()) {
            if (this.getIsHiding()) {
                this.func_184224_h(true);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.wanderAI);
            } else {
                this.func_184224_h(false);
                this.field_70714_bg.func_75776_a(this.wanderAIPriority, (EntityAIBase)this.wanderAI);
                if (this.field_70737_aN > 0) {
                    IAetherStatusEffects.applyStatusEffect((EntityLivingBase)this, IAetherStatusEffects.effectTypes.STUN, 100);
                    this.setToppled(true);
                }
            }
        }
        if (this.getIsToppled()) {
            this.setHiding(false);
        }
        if (!IAetherStatusEffects.doesEffectHaveBuildup((EntityLivingBase)this, IAetherStatusEffects.effectTypes.STUN)) {
            this.setToppled(false);
        }
        if (this.getIsSheared()) {
            ++this.timer;
            if (this.timer > this.timerLimit && !this.field_70170_p.func_72935_r()) {
                this.setSheared(false);
                this.timer = 0;
            }
            this.field_70714_bg.func_75776_a(this.hideAIPriority, (EntityAIBase)this.runeAndHideAI);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.glactrixHideAI);
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.runeAndHideAI);
            this.field_70714_bg.func_75776_a(this.hideAIPriority, (EntityAIBase)this.glactrixHideAI);
        }
    }

    public boolean getIsToppled() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_TOPPLED);
    }

    public boolean getIsHiding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_HIDING);
    }

    public boolean getIsSheared() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SHEARED);
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityGlactrix(this.field_70170_p);
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    protected SoundEvent func_184639_G() {
        return SoundsAether.aerbunny_ambient;
    }

    protected SoundEvent func_184601_bQ(DamageSource src) {
        return SoundsAether.aerbunny_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.aerbunny_death;
    }

    protected ResourceLocation func_184647_J() {
        return LootTablesAether.ENTITY_GLACTRIX;
    }

    public boolean isShearable(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.getIsSheared() && this.getIsToppled();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.setSheared(true);
        this.setToppled(false);
        this.timer = 0;
        int count = 2 + this.field_70146_Z.nextInt(3);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < count; ++i) {
            ret.add(new ItemStack(ItemsAether.icestone));
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("glactrix_refreeze", this.timer);
        compound.func_74757_a("glactrix_sheared", this.getIsSheared());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.timer = compound.func_74762_e("glactrix_refreeze");
        this.setSheared(compound.func_74767_n("glactrix_sheared"));
    }
}

