/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.animals;

import com.gildedgames.aether.api.entity.damage.DamageTypeAttributes;
import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.common.entities.animals.EntityAetherAnimal;
import com.gildedgames.aether.common.init.LootTablesAether;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCarrionSprout
extends EntityAetherAnimal {
    protected Map<String, Float> defenseMap = Maps.newHashMap();
    private static final DataParameter<Integer> SIZE = new DataParameter(13, DataSerializers.field_187192_b);
    @SideOnly(value=Side.CLIENT)
    public float sinage;
    @SideOnly(value=Side.CLIENT)
    public float prevSinage;
    private int maxSproutSize;

    public EntityCarrionSprout(World world) {
        super(world);
        this.defenseMap.put("Very Weak", Float.valueOf(4.0f));
        this.defenseMap.put("Weak", Float.valueOf(2.0f));
        this.defenseMap.put("Average", Float.valueOf(0.0f));
        this.defenseMap.put("Strong", Float.valueOf(-2.0f));
        this.defenseMap.put("Very Strong", Float.valueOf(-4.0f));
        this.func_70105_a(0.5f, 1.5f);
        this.field_175506_bl = BlocksAether.aether_grass;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111128_a(0.0);
        this.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111128_a(0.0);
        this.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111128_a(0.0);
        this.setMaxSproutSize(8);
        int min = 3;
        this.setSproutSize(3 + this.field_70146_Z.nextInt(this.getMaxSproutSize() - 3));
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)0);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound nbt) {
        super.func_189511_e(nbt);
        nbt.func_74768_a("size", this.getSproutSize());
        nbt.func_74768_a("maxSize", this.getMaxSproutSize());
        return nbt;
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.setSproutSize(nbt.func_74762_e("size"));
        this.setMaxSproutSize(nbt.func_74762_e("maxSize"));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.clientUpdate();
        } else if (!this.canStayHere(new BlockPos((Entity)this))) {
            this.func_70606_j(0.0f);
        }
    }

    private boolean canStayHere(BlockPos pos) {
        if (this.field_70170_p.func_180495_p(pos).func_185917_h()) {
            return false;
        }
        IBlockState rootBlock = this.field_70170_p.func_180495_p(pos.func_177977_b());
        return rootBlock.func_177230_c() == BlocksAether.aether_grass || rootBlock.func_177230_c() == BlocksAether.aether_dirt || rootBlock.func_177230_c() == BlocksAether.highlands_snow_layer || rootBlock.func_177230_c() == BlocksAether.highlands_snow;
    }

    public void func_70636_d() {
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        if (this.field_70173_aa == 0) {
            this.func_70101_b(this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
            this.field_70761_aq = this.field_70177_z;
        }
        super.func_70636_d();
        if (!this.isFullyGrown() && this.field_70173_aa % 800 == 0) {
            this.setSproutSize(this.getSproutSize() + 2);
        }
    }

    public boolean isFullyGrown() {
        return this.getSproutSize() >= this.getMaxSproutSize();
    }

    public int getMaxSproutSize() {
        return this.maxSproutSize;
    }

    public void setMaxSproutSize(int x) {
        this.maxSproutSize = x;
    }

    public int getSproutSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    public void setSproutSize(int newSize) {
        this.field_70180_af.func_187227_b(SIZE, (Object)newSize);
    }

    protected ResourceLocation func_184647_J() {
        return LootTablesAether.ENTITY_CARRION_SPROUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void clientUpdate() {
        this.prevSinage = this.sinage;
        this.sinage = this.field_70737_aN > 0 ? (this.sinage += 0.9f) : (this.sinage += 0.15f);
        if (this.sinage > 6.283186f) {
            this.sinage -= 6.283186f;
            this.prevSinage -= 6.283186f;
        }
    }

    public void func_70664_aZ() {
    }

    public void func_70653_a(Entity entityIn, float distance, double motionX, double motionY) {
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }
}

