/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.animals;

import com.gildedgames.aether.api.entity.IEntityEyesComponent;
import com.gildedgames.aether.api.entity.damage.DamageTypeAttributes;
import com.gildedgames.aether.api.entity.effects.EEffectIntensity;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffectIntensity;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffects;
import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.api.registrar.SoundsAether;
import com.gildedgames.aether.common.entities.ai.AetherNavigateGround;
import com.gildedgames.aether.common.entities.ai.EntityAIHideFromRain;
import com.gildedgames.aether.common.entities.ai.EntityAIRamAttack;
import com.gildedgames.aether.common.entities.ai.EntityAIRestrictRain;
import com.gildedgames.aether.common.entities.ai.EntityAIUnstuckBlueAercloud;
import com.gildedgames.aether.common.entities.animals.EntityAetherAnimal;
import com.gildedgames.aether.common.entities.effects.StatusEffectFracture;
import com.gildedgames.aether.common.entities.multipart.AetherMultiPartEntity;
import com.gildedgames.aether.common.entities.util.eyes.EntityEyesComponent;
import com.gildedgames.aether.common.entities.util.eyes.IEntityEyesComponentProvider;
import com.gildedgames.aether.common.init.LootTablesAether;
import com.gildedgames.aether.common.util.helpers.MathUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityBurrukai
extends EntityAetherAnimal
implements IEntityMultiPart,
IEntityEyesComponentProvider {
    protected Map<String, Float> defenseMap = Maps.newHashMap();
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{ItemsAether.brettl_grass});
    private final MultiPartEntityPart[] parts;
    private final MultiPartEntityPart head;
    private EntityAIRamAttack ramAttack;
    private final IEntityEyesComponent eyes;

    public EntityBurrukai(World world) {
        super(world);
        this.defenseMap.put("Very Weak", Float.valueOf(4.0f));
        this.defenseMap.put("Weak", Float.valueOf(2.0f));
        this.defenseMap.put("Average", Float.valueOf(0.0f));
        this.defenseMap.put("Strong", Float.valueOf(-2.0f));
        this.defenseMap.put("Very Strong", Float.valueOf(-4.0f));
        this.head = new AetherMultiPartEntity(this, "head", 0.8f, 1.1f);
        this.eyes = new EntityEyesComponent((EntityLivingBase)this);
        this.parts = new MultiPartEntityPart[]{this.head};
        this.func_70105_a(1.25f, 1.9f);
        this.field_175506_bl = BlocksAether.aether_grass;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.ramAttack = new EntityAIRamAttack((EntityLiving)this, 0.5, 0.5f, 2.0f, 16.0);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.ramAttack);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictRain((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIHideFromRain((EntityCreature)this, 1.3));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIUnstuckBlueAercloud((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public World func_82194_d() {
        return this.func_130014_f_();
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        if (this.field_70172_ad <= 10) {
            return this.func_70097_a(source, damage * 1.1f);
        }
        return false;
    }

    @Nullable
    public MultiPartEntityPart[] getParts() {
        return this.parts;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.eyes.update();
        double prevHeadX = this.head.field_70165_t;
        double prevHeadY = this.head.field_70163_u;
        double prevHeadZ = this.head.field_70161_v;
        float headDist = 1.2f;
        float f = MathUtil.interpolateRotation(this.field_70760_ar, this.field_70761_aq, 1.0f);
        float f1 = MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180) - (float)Math.PI)) * 1.2f;
        float f2 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180) - (float)Math.PI)) * 1.2f;
        this.head.func_70012_b(this.field_70165_t - (double)f2, this.field_70163_u + (double)0.7f, this.field_70161_v - (double)f1, 0.0f, 0.0f);
        this.head.func_70071_h_();
        this.head.field_70169_q = prevHeadX;
        this.head.field_70167_r = prevHeadY;
        this.head.field_70166_s = prevHeadZ;
    }

    @Override
    protected PathNavigate func_175447_b(World worldIn) {
        return new AetherNavigateGround((EntityLiving)this, worldIn);
    }

    @Override
    public float func_180484_a(BlockPos pos) {
        return super.func_180484_a(pos);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111128_a(-2.0);
        this.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111128_a(2.0);
        this.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111128_a(0.0);
    }

    public EntityBurrukai createChild(EntityAgeable ageable) {
        return new EntityBurrukai(this.field_70170_p);
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    protected SoundEvent func_184639_G() {
        return SoundsAether.burrukai_ambient;
    }

    protected SoundEvent func_184601_bQ(DamageSource src) {
        return SoundsAether.burrukai_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.burrukai_death;
    }

    protected float func_70599_aP() {
        return 0.6f;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    protected ResourceLocation func_184647_J() {
        return LootTablesAether.ENTITY_BURRUKAI;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.ramAttack == null) {
            return;
        }
        this.ramAttack.update();
        this.func_70624_b(this.func_70638_az());
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
            this.func_70624_b(attacker);
            if (!(this.ramAttack == null || attacker instanceof EntityPlayer && ((EntityPlayer)attacker).func_184812_l_())) {
                this.ramAttack.setTarget(attacker);
            }
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entityIn;
            double xRatio = this.func_70676_i((float)1.0f).field_72450_a * 360.0;
            double zRatio = this.func_70676_i((float)1.0f).field_72449_c * 360.0;
            living.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 5.0f);
            this.func_184185_a(SoundsAether.burrukai_attack, 0.5f, 1.0f);
            living.func_70653_a((Entity)this, 1.0f, xRatio * -1.0, zRatio * -1.0);
            this.applyStatusEffectOnAttack(entityIn);
            this.ramAttack.setTarget(this.func_70638_az());
            this.func_70624_b(null);
        }
        return true;
    }

    @Override
    protected void applyStatusEffectOnAttack(Entity target) {
        EntityLivingBase living;
        if (target instanceof EntityLivingBase && !(living = (EntityLivingBase)target).func_184585_cz()) {
            int buildup = IAetherStatusEffectIntensity.getBuildupFromEffect(new StatusEffectFracture(living), EEffectIntensity.ORDINARY);
            IAetherStatusEffects.applyStatusEffect(living, IAetherStatusEffects.effectTypes.FRACTURE, buildup);
        }
    }

    @Override
    public IEntityEyesComponent getEyes() {
        return this.eyes;
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.func_70653_a(entityIn, strength * 0.2f, xRatio, zRatio);
    }
}

