/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.animals;

import com.gildedgames.aether.api.entity.damage.DamageTypeAttributes;
import com.gildedgames.aether.api.entity.damage.IDefenseLevelsHolder;
import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.api.registrar.ItemsAether;
import com.gildedgames.aether.api.registrar.SoundsAether;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.entities.ai.AetherNavigateGround;
import com.gildedgames.aether.common.entities.ai.EntityAIEggnogTempt;
import com.gildedgames.aether.common.entities.ai.EntityAIHideFromRain;
import com.gildedgames.aether.common.entities.ai.EntityAIRestrictRain;
import com.gildedgames.aether.common.entities.ai.EntityAIUnstuckBlueAercloud;
import com.gildedgames.aether.common.init.LootTablesAether;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketAerbunnySetRiding;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAerbunny
extends EntityTameable
implements IDefenseLevelsHolder {
    protected Map<String, Float> defenseMap = Maps.newHashMap();
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{ItemsAether.blueberries});
    private static final Set<Item> TAMING_ITEMS = Sets.newHashSet((Object[])new Item[]{ItemsAether.orange});
    private static final Set<Item> HEALING_ITEMS = Sets.newHashSet((Object[])new Item[]{ItemsAether.orange});
    private static final DataParameter<Integer> COLLAR_COLOR = EntityDataManager.func_187226_a(EntityAerbunny.class, (DataSerializer)DataSerializers.field_187192_b);
    @SideOnly(value=Side.CLIENT)
    private double prevMotionY;
    @SideOnly(value=Side.CLIENT)
    private int puffiness;
    @SideOnly(value=Side.CLIENT)
    private float curRotation;
    private boolean quickFall;

    public EntityAerbunny(World world) {
        super(world);
        this.defenseMap.put("Very Weak", Float.valueOf(4.0f));
        this.defenseMap.put("Weak", Float.valueOf(2.0f));
        this.defenseMap.put("Average", Float.valueOf(0.0f));
        this.defenseMap.put("Strong", Float.valueOf(-2.0f));
        this.defenseMap.put("Very Strong", Float.valueOf(-4.0f));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictRain((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIUnstuckBlueAercloud((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIHideFromRain((EntityCreature)this, 1.3));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIEggnogTempt((EntityCreature)this, 2.2));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.5, 5.0f, 2.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 10));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 12.0f, (double)1.2f, (double)1.8f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70767_i = new AerbunnyJumpHelper(this);
        this.field_175506_bl = BlocksAether.aether_grass;
        this.func_70105_a(0.65f, 0.65f);
        this.func_70903_f(false);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLLAR_COLOR, (Object)EnumDyeColor.BLUE.func_176767_b());
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == BlocksAether.aether_grass ? 10.0f : this.field_70170_p.func_175724_o(pos) - 0.5f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(DamageTypeAttributes.SLASH_DEFENSE_LEVEL).func_111128_a(2.0);
        this.func_110148_a(DamageTypeAttributes.IMPACT_DEFENSE_LEVEL).func_111128_a(-2.0);
        this.func_110148_a(DamageTypeAttributes.PIERCE_DEFENSE_LEVEL).func_111128_a(0.0);
    }

    public void func_70071_h_() {
        if (this.field_70159_w != 0.0 || this.field_70179_y != 0.0) {
            this.func_70637_d(true);
        }
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.puffiness > 0) {
                --this.puffiness;
            }
            if (this.prevMotionY <= 0.0 && this.field_70181_x > 0.0) {
                BlockPos pos = this.func_180425_c();
                if (this.field_70170_p.func_175665_u(pos.func_177977_b())) {
                    AetherCore.PROXY.spawnJumpParticles(this.field_70170_p, this.field_70165_t, pos.func_177956_o(), this.field_70161_v, 0.6, 6);
                }
                this.puffiness = 10;
            }
            this.prevMotionY = this.field_70181_x;
        }
        if (this.func_184218_aH()) {
            Entity entity = this.func_184187_bx();
            if (!this.field_70170_p.field_72995_K) {
                if (entity.func_70093_af()) {
                    if (entity.field_70122_E && !this.quickFall) {
                        NetworkingAether.sendPacketToWatching(new PacketAerbunnySetRiding(null, this), (EntityLivingBase)this, false);
                        this.func_184210_p();
                        this.func_70107_b(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() + 0.5, entity.field_70161_v);
                    } else {
                        this.quickFall = true;
                    }
                } else {
                    this.quickFall = false;
                }
            }
            if (entity.field_70181_x < 0.0) {
                entity.field_70181_x = entity.field_70181_x * (entity.func_70093_af() ? 0.9 : 0.7);
                entity.field_70143_R = 0.0f;
            }
            this.func_70101_b(entity.field_70177_z, entity.field_70125_A);
        }
        if (this.field_70181_x < -0.1) {
            this.field_70181_x = -0.1;
        }
        this.field_70143_R = 0.0f;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemFood) {
                ItemFood itemfood = (ItemFood)itemstack.func_77973_b();
                if (this.isHealingItem(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    this.func_70691_i(itemfood.func_150905_g(itemstack));
                    return true;
                }
            }
            if (this.func_152114_e((EntityLivingBase)player) && !this.field_70170_p.field_72995_K && !this.func_70877_b(itemstack) && !this.isTamingItem(itemstack) && !this.isHealingItem(itemstack) && player.func_70093_af()) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
            }
        } else if (this.isTamingItem(itemstack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.field_70699_by.func_75499_g();
                    this.field_70911_d.func_75270_a(true);
                    this.func_70606_j(this.func_110138_aP());
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        if (!(super.func_184645_a(player, hand) || this.func_70877_b(itemstack) || this.isTamingItem(itemstack) || this.isHealingItem(itemstack) || player.func_70093_af() || this.func_70906_o())) {
            if (!this.func_184218_aH() && player.func_184188_bt().size() <= 0) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_184205_a((Entity)player, true);
                    NetworkingAether.sendPacketToWatching(new PacketAerbunnySetRiding(player, this), (EntityLivingBase)this, false);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public double func_70033_W() {
        return this.func_184187_bx() != null ? 0.45 : 0.0;
    }

    protected ResourceLocation func_184647_J() {
        return LootTablesAether.ENTITY_AERBUNNY;
    }

    protected SoundEvent func_184639_G() {
        return SoundsAether.aerbunny_ambient;
    }

    protected SoundEvent func_184601_bQ(DamageSource src) {
        return SoundsAether.aerbunny_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.aerbunny_death;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new AetherNavigateGround((EntityLiving)this, worldIn);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityAerbunny entityAerbunny = new EntityAerbunny(this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            entityAerbunny.func_184754_b(uuid);
            entityAerbunny.func_70903_f(true);
        }
        return entityAerbunny;
    }

    @SideOnly(value=Side.CLIENT)
    public int getPuffiness() {
        return this.puffiness;
    }

    @SideOnly(value=Side.CLIENT)
    public float getRotation() {
        if (this.field_70181_x > 0.0) {
            this.curRotation += MathHelper.func_76131_a((float)(this.curRotation / 10.0f), (float)-4.0f, (float)-2.0f);
        } else if (this.field_70181_x < 0.0) {
            this.curRotation += MathHelper.func_76131_a((float)(this.curRotation / 10.0f), (float)2.0f, (float)4.0f);
        }
        if (this.field_70122_E) {
            this.curRotation = 0.0f;
        }
        this.curRotation = MathHelper.func_76131_a((float)this.curRotation, (float)-30.0f, (float)30.0f);
        return this.curRotation;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    public boolean isTamingItem(@Nullable ItemStack stack) {
        return stack != null && TAMING_ITEMS.contains(stack.func_77973_b());
    }

    public boolean isHealingItem(@Nullable ItemStack stack) {
        return stack != null && HEALING_ITEMS.contains(stack.func_77973_b());
    }

    public EnumDyeColor getCollarColor() {
        return EnumDyeColor.func_176766_a((int)((Integer)this.field_70180_af.func_187225_a(COLLAR_COLOR) & 0xF));
    }

    public void setCollarColor(EnumDyeColor collarColor) {
        this.field_70180_af.func_187227_b(COLLAR_COLOR, (Object)collarColor.func_176767_b());
    }

    public boolean func_70094_T() {
        return !this.func_184218_aH() && super.func_70094_T();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("CollarColor", (byte)this.getCollarColor().func_176767_b());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("CollarColor", 99)) {
            this.setCollarColor(EnumDyeColor.func_176766_a((int)compound.func_74771_c("CollarColor")));
        }
    }

    private class AerbunnyNavigator
    extends AetherNavigateGround {
        public AerbunnyNavigator(EntityLiving entity, World world) {
            super(entity, world);
        }

        protected boolean func_75485_k() {
            return !this.field_75515_a.func_184218_aH();
        }
    }

    private class AerbunnyJumpHelper
    extends EntityJumpHelper {
        private final EntityLiving entity;

        public AerbunnyJumpHelper(EntityAerbunny entity) {
            super((EntityLiving)entity);
            this.entity = entity;
        }

        public void func_75661_b() {
            this.entity.func_70637_d(true);
            if (this.entity.field_70159_w == 0.0 && this.entity.field_70179_y == 0.0) {
                this.field_75662_b = false;
                this.entity.func_70637_d(false);
            }
        }
    }
}

