/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.ai.moa;

import com.gildedgames.aether.api.registrar.BlocksAether;
import com.gildedgames.aether.common.blocks.natural.plants.BlockWovenSticks;
import com.gildedgames.aether.common.entities.animals.EntityMoa;
import com.gildedgames.aether.common.entities.genes.AnimalGender;
import com.gildedgames.aether.common.entities.genes.moa.MoaGenePool;
import com.gildedgames.aether.common.entities.tiles.TileEntityMoaEgg;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AIMoaPackBreeding
extends EntityAIBase {
    public final World world;
    public final EntityMoa moa;
    public EntityLiving packLeader;
    public final float moveSpeed;
    public BlockPos eggPos;
    public int timeUntilLay;

    public AIMoaPackBreeding(EntityMoa moa, float moveSpeed) {
        this.world = moa.field_70170_p;
        this.moveSpeed = moveSpeed;
        this.moa = moa;
    }

    public void resetTimer() {
        this.timeUntilLay = 30 + this.moa.func_70681_au().nextInt(60);
    }

    public boolean func_75250_a() {
        if (this.moa == null || this.world == null) {
            return false;
        }
        if (this.moa.func_70631_g_()) {
            return false;
        }
        if (this.moa.getFamilyNest() == null) {
            return false;
        }
        if (!this.moa.getFamilyNest().hasInitialized) {
            return false;
        }
        this.eggPos = this.moa.getFamilyNest().pos.func_177982_a(0, 1, 0);
        if (this.world.func_180495_p(this.eggPos).func_177230_c() == BlocksAether.moa_egg) {
            this.resetTimer();
            return false;
        }
        if (!(this.world.func_180495_p(this.moa.getFamilyNest().pos).func_177230_c() instanceof BlockWovenSticks)) {
            return false;
        }
        if (this.timeUntilLay > 0) {
            if (this.moa.field_70173_aa % 20 == 0) {
                --this.timeUntilLay;
            }
            return false;
        }
        return true;
    }

    public void func_75246_d() {
        boolean isNearEgg;
        super.func_75246_d();
        Path path = this.moa.func_70661_as().func_75505_d();
        boolean bl = isNearEgg = this.moa.func_70092_e(this.eggPos.func_177958_n() - 1, this.eggPos.func_177956_o(), this.eggPos.func_177952_p() - 1) <= 4.0;
        if ((path == null || path.func_75879_b()) && !isNearEgg) {
            this.moa.func_70661_as().func_75492_a((double)(this.eggPos.func_177958_n() - 1), (double)this.eggPos.func_177956_o(), (double)(this.eggPos.func_177952_p() - 1), (double)this.moveSpeed);
        } else if (isNearEgg && this.moa.func_70661_as().func_75505_d() != null && this.moa.func_70661_as().func_75505_d().func_75879_b()) {
            this.world.func_175656_a(this.eggPos, BlocksAether.moa_egg.func_176223_P());
            TileEntityMoaEgg egg = (TileEntityMoaEgg)this.world.func_175625_s(this.eggPos);
            if (egg != null) {
                MoaGenePool teGenes = egg.getGenePool();
                MoaGenePool entityGenes = (MoaGenePool)this.moa.getGenePool();
                teGenes.transformFromParents(entityGenes.getStorage().getSeed(), entityGenes.getStorage().getFatherSeed(), entityGenes.getStorage().getMotherSeed());
                egg.setFamilyNest(this.moa.getFamilyNest());
                if (!this.moa.getAnimalPack().hasLeader()) {
                    egg.setGender(AnimalGender.MALE);
                }
            }
            this.moa.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.moa.func_70681_au().nextFloat() - this.moa.func_70681_au().nextFloat()) * 0.2f + 1.0f);
            this.resetTimer();
        }
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }
}

