/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.ai.hopping;

import java.util.function.Supplier;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.util.SoundEvent;

public class HoppingMoveHelper
extends EntityMoveHelper {
    private final EntityLiving entity;
    private float yRot;
    private int jumpDelay;
    private final Supplier<SoundEvent> hoppingSound;
    private HopTimer hopTimer;
    private boolean active;

    public HoppingMoveHelper(EntityLiving entity, Supplier<SoundEvent> hoppingSound, HopTimer hopTimer) {
        super(entity);
        this.hopTimer = hopTimer;
        this.hoppingSound = hoppingSound;
        this.entity = entity;
        this.yRot = 180.0f * entity.field_70177_z / (float)Math.PI;
        this.active = true;
    }

    public HoppingMoveHelper(EntityLiving entity, Supplier<SoundEvent> hoppingSound) {
        this(entity, hoppingSound, () -> entity.func_70681_au().nextInt(20) + 10);
    }

    public void setDirection(float p_179920_1_) {
        this.yRot = p_179920_1_;
    }

    public void setSpeed(double speedIn) {
        this.field_75645_e = speedIn;
        this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
    }

    public void setTime(HopTimer timer) {
        this.hopTimer = timer;
    }

    public HopTimer getTimer() {
        return this.hopTimer;
    }

    public void func_75641_c() {
        this.entity.field_70759_as = this.entity.field_70177_z = this.func_75639_a(this.entity.field_70177_z, this.yRot, 90.0f);
        this.entity.field_70761_aq = this.entity.field_70177_z;
        if (!this.active) {
            return;
        }
        if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
            this.entity.func_191989_p(0.0f);
        } else {
            this.field_188491_h = EntityMoveHelper.Action.WAIT;
            if (this.entity.field_70122_E) {
                this.entity.func_70659_e((float)(this.field_75645_e * this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (this.jumpDelay-- <= 0) {
                    this.jumpDelay = this.hopTimer.jumpDelay();
                    this.entity.func_70683_ar().func_75660_a();
                    this.entity.func_184185_a(this.hoppingSound.get(), 0.5f, ((this.entity.func_70681_au().nextFloat() - this.entity.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                } else {
                    this.entity.field_70702_br = 0.0f;
                    this.entity.field_191988_bg = 0.0f;
                    this.entity.func_70659_e(0.0f);
                }
            } else {
                this.entity.func_70659_e((float)(this.field_75645_e * this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
            }
        }
    }

    public void setActive(boolean isActive) {
        if (!isActive) {
            this.entity.func_70659_e(0.0f);
        } else {
            this.entity.func_70659_e((float)(this.field_75645_e * this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
        }
        this.active = isActive;
    }

    public static interface HopTimer {
        public int jumpDelay();
    }
}

