/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.ai;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class EntityAIWanderFavorBlocks
extends EntityAIBase {
    protected final EntityCreature entity;
    protected double x;
    protected double y;
    protected double z;
    protected final double speed;
    protected int executionChance;
    protected final ArrayList<Block> favoriteBlocks;
    protected boolean mustUpdate;

    public EntityAIWanderFavorBlocks(EntityCreature creatureIn, double speedIn, ArrayList<Block> favoriteBlocks) {
        this(creatureIn, speedIn, 60, favoriteBlocks);
    }

    public EntityAIWanderFavorBlocks(EntityCreature creatureIn, double speedIn, int chance, ArrayList<Block> favoriteBlocks) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.favoriteBlocks = favoriteBlocks;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        Vec3d vec3d;
        if (!this.mustUpdate) {
            if (this.entity.func_70654_ax() >= 100) {
                return false;
            }
            if (this.entity.func_70681_au().nextInt(this.executionChance) != 0) {
                return false;
            }
        }
        if ((vec3d = this.getPosition()) == null) {
            return false;
        }
        return this.setPosFromVec(vec3d);
    }

    private boolean setPosFromVec(Vec3d vec3d) {
        this.x = vec3d.field_72450_a;
        this.y = vec3d.field_72448_b;
        this.z = vec3d.field_72449_c;
        this.mustUpdate = false;
        return true;
    }

    @Nullable
    protected Vec3d getPosition() {
        if (!this.favoriteBlocks.isEmpty()) {
            for (int i = 0; i < 10; ++i) {
                BlockPos blockPos;
                Block potential;
                Vec3d pos = RandomPositionGenerator.func_75463_a((EntityCreature)this.entity, (int)10, (int)4);
                if (pos == null || !this.favoriteBlocks.contains(potential = this.entity.field_70170_p.func_180495_p(blockPos = new BlockPos(pos)).func_177230_c())) continue;
                return pos;
            }
        }
        if (this.entity.func_70681_au().nextInt(8) == 0) {
            return RandomPositionGenerator.func_75463_a((EntityCreature)this.entity, (int)10, (int)7);
        }
        return null;
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75492_a(this.x, this.y, this.z, this.speed);
        if (!this.entity.func_70661_as().func_75500_f()) {
            Path path = this.entity.func_70661_as().func_75505_d();
            for (int i = path.func_75873_e(); i < path.func_75874_d(); ++i) {
                PathPoint pp = path.func_75877_a(i);
                BlockPos blockPos = new BlockPos(pp.field_75839_a, pp.field_75837_b, pp.field_75838_c);
                if (this.entity.field_70170_p.func_175678_i(blockPos)) continue;
            }
        }
    }

    public void markUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int newChance) {
        this.executionChance = newChance;
    }
}

