/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.ai;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class EntityAIWanderAvoidLight
extends EntityAIBase {
    protected final EntityCreature entity;
    protected double x;
    protected double y;
    protected double z;
    protected final double speed;
    protected int executionChance;
    protected final int lightLevel;
    protected boolean mustUpdate;

    public EntityAIWanderAvoidLight(EntityCreature creatureIn, double speedIn, int lightLevel) {
        this(creatureIn, speedIn, 120, lightLevel);
    }

    public EntityAIWanderAvoidLight(EntityCreature creatureIn, double speedIn, int chance, int lightLevel) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.lightLevel = lightLevel;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        Vec3d vec3d;
        if (!this.mustUpdate) {
            if (this.entity.func_70654_ax() >= 100) {
                return false;
            }
            if (this.entity.func_70681_au().nextInt(this.executionChance) != 0) {
                return false;
            }
        }
        if ((vec3d = this.getPosition()) == null) {
            return false;
        }
        this.x = vec3d.field_72450_a;
        this.y = vec3d.field_72448_b;
        this.z = vec3d.field_72449_c;
        this.mustUpdate = false;
        return true;
    }

    @Nullable
    protected Vec3d getPosition() {
        for (int i = 0; i < 10; ++i) {
            BlockPos blockPos;
            Vec3d pos = RandomPositionGenerator.func_75463_a((EntityCreature)this.entity, (int)10, (int)7);
            if (pos == null || this.entity.field_70170_p.func_175671_l(blockPos = new BlockPos(pos)) > this.lightLevel || this.entity.field_70170_p.func_72935_r() && this.entity.field_70170_p.func_175678_i(blockPos)) continue;
            return pos;
        }
        return null;
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75492_a(this.x, this.y, this.z, this.speed);
        if (!this.entity.func_70661_as().func_75500_f()) {
            Path path = this.entity.func_70661_as().func_75505_d();
            for (int i = path.func_75873_e(); i < path.func_75874_d(); ++i) {
                PathPoint pp = path.func_75877_a(i);
                BlockPos blockPos = new BlockPos(pp.field_75839_a, pp.field_75837_b, pp.field_75838_c);
                if (this.entity.field_70170_p.func_175671_l(blockPos) <= this.lightLevel && (!this.entity.field_70170_p.func_72935_r() || !this.entity.field_70170_p.func_175678_i(blockPos))) continue;
                this.entity.func_70661_as().func_75499_g();
            }
        }
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int newchance) {
        this.executionChance = newchance;
    }
}

