/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class EntityAIMoveToBlockYSensitive
extends EntityAIBase {
    private final EntityCreature creature;
    private final double movementSpeed;
    private final int searchLength;
    protected int runDelay;
    protected BlockPos destinationBlock = BlockPos.field_177992_a;
    private int timeoutCounter;
    private int maxStayTicks;
    private boolean isAboveDestination;

    public EntityAIMoveToBlockYSensitive(EntityCreature creature, double speedIn, int length) {
        this.creature = creature;
        this.movementSpeed = speedIn;
        this.searchLength = length;
        this.func_75248_a(5);
    }

    public boolean func_75250_a() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = 200 + this.creature.func_70681_au().nextInt(200);
        return this.searchForDestination();
    }

    public boolean func_75253_b() {
        return this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200 && this.shouldMoveTo(this.creature.field_70170_p, this.destinationBlock);
    }

    public void func_75249_e() {
        this.creature.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
        this.timeoutCounter = 0;
        this.maxStayTicks = this.creature.func_70681_au().nextInt(this.creature.func_70681_au().nextInt(1200) + 1200) + 1200;
    }

    public void func_75246_d() {
        if (this.creature.func_174831_c(this.destinationBlock.func_177984_a()) > 1.0) {
            this.isAboveDestination = false;
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.creature.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
            }
        } else {
            this.isAboveDestination = true;
            --this.timeoutCounter;
        }
    }

    protected boolean getIsAboveDestination() {
        return this.isAboveDestination;
    }

    private boolean searchForDestination() {
        int i = this.searchLength;
        boolean j = true;
        BlockPos blockpos = new BlockPos((Entity)this.creature);
        int heightSearch = 4;
        for (int k = -4; k < 4; ++k) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        BlockPos blockpos1 = blockpos.func_177982_a(i1, k, j1);
                        if (this.creature.func_180485_d(blockpos1) && this.shouldMoveTo(this.creature.field_70170_p, blockpos1)) {
                            this.destinationBlock = blockpos1;
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
        }
        return false;
    }

    protected abstract boolean shouldMoveTo(World var1, BlockPos var2);
}

