/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.ai;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAIHideFromTarget
extends EntityAIBase {
    static final int maxDist = 12;
    static final int minDist = 4;
    private final double movementSpeed;
    protected EntityLivingBase hideFrom;
    final EntityCreature entity;
    final Class<? extends EntityLivingBase> hideFromClass;
    private BlockPos hidingPos;

    public EntityAIHideFromTarget(EntityCreature entity, Class<? extends EntityLivingBase> clazz, double movementSpeed) {
        this.entity = entity;
        this.hideFromClass = clazz;
        this.movementSpeed = movementSpeed;
    }

    public boolean func_75250_a() {
        if (this.hidingPos != null) {
            return true;
        }
        List entities = this.entity.field_70170_p.func_72872_a(this.hideFromClass, this.entity.func_174813_aQ().func_72321_a(12.0, 12.0, 12.0));
        if (entities.isEmpty()) {
            return false;
        }
        EntityLivingBase toHideFrom = null;
        for (Object o : entities) {
            if (!(o instanceof EntityLivingBase) || o instanceof EntityPlayer && ((EntityPlayer)o).func_184812_l_()) continue;
            toHideFrom = (EntityLivingBase)o;
        }
        if (toHideFrom == null) {
            return false;
        }
        this.hideFrom = toHideFrom;
        if (!this.hideFrom.func_70685_l((Entity)this.entity)) {
            return false;
        }
        Vec3d spot = this.findHidingSpot();
        if (spot == null) {
            return false;
        }
        this.hidingPos = new BlockPos(spot.field_72450_a, spot.field_72448_b, spot.field_72449_c);
        return true;
    }

    public boolean func_75253_b() {
        return this.hidingPos != null;
    }

    public void func_75249_e() {
        Path path = this.entity.func_70661_as().func_179680_a(this.hidingPos);
        this.entity.func_70661_as().func_75484_a(path, this.movementSpeed);
    }

    public void func_75246_d() {
        if (this.entity.func_70661_as().func_75500_f() && this.hideFrom.func_70685_l((Entity)this.entity)) {
            this.hidingPos = null;
        }
    }

    protected Vec3d findHidingSpot() {
        Random random = this.entity.func_70681_au();
        World world = this.entity.field_70170_p;
        for (int i = 0; i < 13; ++i) {
            int j = MathHelper.func_76128_c((double)(this.entity.field_70165_t + (double)random.nextInt(20) - 10.0));
            int k = MathHelper.func_76128_c((double)(this.entity.func_174813_aQ().field_72338_b + (double)random.nextInt(6) - 3.0));
            int l = MathHelper.func_76128_c((double)(this.entity.field_70161_v + (double)random.nextInt(20) - 10.0));
            RayTraceResult raytrace = world.func_72933_a(new Vec3d((double)j, (double)((float)k + this.entity.func_70047_e()), (double)l), new Vec3d(this.hideFrom.field_70165_t, this.hideFrom.field_70163_u + (double)this.hideFrom.func_70047_e(), this.hideFrom.field_70161_v));
            if (raytrace == null || raytrace.field_72313_a == null) continue;
            return new Vec3d((double)j, (double)k, (double)l);
        }
        return null;
    }
}

