/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.entities.ai;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAIHideFromLight
extends EntityAIBase {
    private final float movementSpeed;
    private final EntityCreature entity;
    private final int lightLevel;
    private double shelterX;
    private double shelterY;
    private double shelterZ;
    private boolean enabled;

    public EntityAIHideFromLight(EntityCreature entity, float movementSpeed, int lightLevel) {
        this.entity = entity;
        this.movementSpeed = movementSpeed;
        this.lightLevel = lightLevel;
        this.enabled = true;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.entity == null || !this.enabled) {
            return false;
        }
        World world = this.entity.field_70170_p;
        if (!world.func_72935_r()) {
            return false;
        }
        if (!world.func_175678_i(new BlockPos(this.entity.field_70165_t, this.entity.func_174813_aQ().field_72338_b, this.entity.field_70161_v))) {
            return false;
        }
        BlockPos entityPos = new BlockPos(this.entity.field_70165_t, this.entity.func_174813_aQ().field_72338_b, this.entity.field_70161_v);
        if (this.entity.field_70170_p.func_175671_l(entityPos) <= this.lightLevel) {
            return false;
        }
        Vec3d vec3d = this.findPossibleShelter();
        if (vec3d == null) {
            return false;
        }
        this.shelterX = vec3d.field_72450_a;
        this.shelterY = vec3d.field_72448_b;
        this.shelterZ = vec3d.field_72449_c;
        return true;
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75492_a(this.shelterX, this.shelterY, this.shelterZ, (double)this.movementSpeed);
    }

    @Nullable
    private Vec3d findPossibleShelter() {
        Random random = this.entity.func_70681_au();
        BlockPos blockpos = new BlockPos(this.entity.field_70165_t, this.entity.func_174813_aQ().field_72338_b, this.entity.field_70161_v);
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.func_177982_a(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
            if (this.entity.field_70170_p.func_175671_l(blockpos1) > this.lightLevel) continue;
            return new Vec3d((double)blockpos1.func_177958_n(), (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p());
        }
        return null;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }
}

