/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.dialog.data.slide_renderers;

import com.gildedgames.aether.api.dialog.IDialogSlide;
import com.gildedgames.aether.api.dialog.IDialogSlideRenderer;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;

public class DialogSlideRendererStatic
implements IDialogSlideRenderer {
    private ResourceLocation slideTexture;
    private double scale = 1.0;
    private int width;
    private int height;

    @Override
    public void setup(IDialogSlide slide) {
        if (!slide.getSlideData().isPresent()) {
            return;
        }
        Map<String, String> data = slide.getSlideData().get();
        if (data.containsKey("resource")) {
            this.slideTexture = new ResourceLocation(data.get("resource"));
        }
        if (data.containsKey("scale")) {
            this.scale = Double.valueOf(data.get("scale"));
        }
        if (data.containsKey("width")) {
            this.width = Integer.valueOf(data.get("width"));
        }
        if (data.containsKey("height")) {
            this.height = Integer.valueOf(data.get("height"));
        }
    }

    @Override
    public void draw(IDialogSlide slide, double screenWidth, double screenHeight, int mouseX, int mouseY, float partialTicks) {
        if (this.slideTexture == null) {
            return;
        }
        TextureManager textureManager = Minecraft.func_71410_x().field_71446_o;
        double scaledWidth = (double)this.width * this.scale;
        double scaledHeight = (double)this.height * this.scale;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(screenWidth / 2.0 - scaledWidth / 2.0), (double)(screenHeight - 90.0 - scaledHeight), (double)0.0);
        GlStateManager.func_179139_a((double)this.scale, (double)this.scale, (double)this.scale);
        textureManager.func_110577_a(this.slideTexture);
        Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (float)this.width, (float)this.height);
        GlStateManager.func_179121_F();
    }

    public static class Deserializer
    implements JsonDeserializer<DialogSlideRendererStatic> {
        public DialogSlideRendererStatic deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new DialogSlideRendererStatic();
        }
    }
}

