/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.dialog.data;

import com.gildedgames.aether.api.dialog.IDialogAction;
import com.gildedgames.aether.api.dialog.IDialogButton;
import com.gildedgames.aether.api.dialog.IDialogCondition;
import com.gildedgames.aether.api.dialog.IDialogLine;
import com.gildedgames.aether.api.dialog.IDialogNode;
import com.gildedgames.aether.api.dialog.IDialogScene;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class DialogSchema
implements IDialogScene {
    @SerializedName(value="nodes")
    private Collection<DialogNodeSchema> nodes;
    private String startingNodeId;

    @Override
    public Optional<IDialogNode> getNode(String id) {
        for (DialogNodeSchema node : this.nodes) {
            if (!id.equals(node.getIdentifier())) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public IDialogNode getStartingNode() {
        return this.getNode(this.startingNodeId).orElseThrow(() -> new IllegalArgumentException("Couldn't find starting node with id: '" + this.startingNodeId + "'"));
    }

    @Override
    public void setStartingNode(String id) {
        this.startingNodeId = id;
    }

    private class DialogLineSchema
    implements IDialogLine {
        @SerializedName(value="speaker")
        private final String speaker;
        @SerializedName(value="text")
        private String text;

        private DialogLineSchema() {
            this.speaker = null;
        }

        @Override
        public ITextComponent getLocalizedBody() {
            return new TextComponentTranslation(this.text, new Object[0]);
        }

        @Override
        public Optional<ResourceLocation> getSpeaker() {
            return this.speaker != null ? Optional.of(new ResourceLocation(this.speaker)) : Optional.empty();
        }
    }

    private class DialogButtonSchema
    implements IDialogButton {
        @SerializedName(value="orConditions")
        private Collection<IDialogCondition> orConditions;
        @SerializedName(value="conditions")
        private Collection<IDialogCondition> conditions;
        @SerializedName(value="label")
        private String label;
        @SerializedName(value="actions")
        private Collection<IDialogAction> actions;

        private DialogButtonSchema() {
        }

        @Override
        @Nonnull
        public Collection<IDialogCondition> getOrConditions() {
            return this.orConditions == null ? Collections.emptyList() : this.orConditions;
        }

        @Override
        @Nonnull
        public Collection<IDialogCondition> getConditions() {
            return this.conditions == null ? Collections.emptyList() : this.conditions;
        }

        @Override
        @Nonnull
        public String getLabel() {
            return this.label;
        }

        @Override
        @Nonnull
        public ITextComponent getLocalizedLabel() {
            return new TextComponentTranslation(this.label, new Object[0]);
        }

        @Override
        @Nonnull
        public Collection<IDialogAction> getActions() {
            return this.actions;
        }
    }

    private class DialogNodeSchema
    implements IDialogNode {
        @SerializedName(value="buttons")
        private final List<DialogButtonSchema> buttons = null;
        @SerializedName(value="end_actions")
        private final Collection<IDialogAction> actions = null;
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="lines")
        private List<DialogLineSchema> lines;

        private DialogNodeSchema() {
        }

        @Override
        @Nonnull
        public List<IDialogLine> getLines() {
            return Collections.unmodifiableList(this.lines);
        }

        @Override
        @Nonnull
        public Collection<IDialogButton> getButtons() {
            return this.buttons == null ? Collections.emptyList() : Collections.unmodifiableList(this.buttons);
        }

        @Override
        @Nonnull
        public Collection<IDialogAction> getEndActions() {
            return this.actions == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.actions);
        }

        @Override
        @Nonnull
        public String getIdentifier() {
            return this.name;
        }
    }
}

