/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.dialog.data;

import com.gildedgames.aether.api.dialog.IDialogAction;
import com.gildedgames.aether.api.dialog.IDialogButton;
import com.gildedgames.aether.api.dialog.IDialogCondition;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.Validate;

public class DialogButton
implements IDialogButton {
    private final String label;
    private final Collection<IDialogAction> actions;
    private final Collection<IDialogCondition> conditions;
    private final Collection<IDialogCondition> orConditions;

    public DialogButton(Collection<IDialogCondition> orConditions, Collection<IDialogCondition> conditions, String label, Collection<IDialogAction> actions) {
        Validate.notNull(orConditions, (String)"orConditions are null", (Object[])new Object[0]);
        Validate.notNull(conditions, (String)"Conditions are null", (Object[])new Object[0]);
        Validate.notNull(actions, (String)"Actions are null", (Object[])new Object[0]);
        this.orConditions = orConditions;
        this.conditions = conditions;
        this.label = label;
        this.actions = actions;
    }

    @Override
    @Nonnull
    public Collection<IDialogCondition> getOrConditions() {
        return this.orConditions;
    }

    @Override
    @Nonnull
    public Collection<IDialogCondition> getConditions() {
        return this.conditions;
    }

    @Override
    @Nonnull
    public String getLabel() {
        return this.label;
    }

    @Override
    @Nonnull
    public ITextComponent getLocalizedLabel() {
        return new TextComponentString(this.label);
    }

    @Override
    @Nonnull
    public Collection<IDialogAction> getActions() {
        return this.actions;
    }
}

