/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.dialog;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.dialog.IDialogController;
import com.gildedgames.aether.api.dialog.IDialogSlide;
import com.gildedgames.aether.api.dialog.IDialogSlideRenderer;
import com.gildedgames.aether.api.dialog.IDialogSpeaker;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class DialogUtil {
    public static IDialogSpeaker getCurrentSpeaker(IDialogController controller) {
        if (!controller.getCurrentLine().getSpeaker().isPresent()) {
            return null;
        }
        ResourceLocation speakerPath = controller.getCurrentLine().getSpeaker().get();
        return AetherAPI.content().dialog().getSpeaker(speakerPath).orElseThrow(() -> new IllegalArgumentException("Couldn't getByte speaker: " + speakerPath));
    }

    public static IDialogSlide getSlide(IDialogController controller) {
        Map<String, IDialogSlide> slides;
        if (!controller.getCurrentLine().getSpeaker().isPresent()) {
            return null;
        }
        ResourceLocation speakerPath = controller.getCurrentLine().getSpeaker().get();
        IDialogSpeaker speaker = AetherAPI.content().dialog().getSpeaker(speakerPath).orElseThrow(() -> new IllegalArgumentException("Couldn't getByte speaker: " + speakerPath));
        IDialogSlide slide = null;
        if (speakerPath.func_110623_a().contains("#")) {
            String address = speakerPath.func_110623_a().substring(speakerPath.func_110623_a().indexOf("#") + 1);
            slide = AetherAPI.content().dialog().findSlide(address, speaker).orElseThrow(() -> new IllegalArgumentException("Couldn't find slide: " + address));
        } else if (speaker.getSlides().isPresent() && !(slides = speaker.getSlides().get()).isEmpty() && slides.containsKey("default")) {
            slide = slides.get("default");
        }
        return slide;
    }

    public static IDialogSlideRenderer getRenderer(IDialogSlide slide) {
        IDialogSlideRenderer renderer = null;
        if (slide != null && slide.getRenderer().isPresent()) {
            String renderType = slide.getRenderer().get();
            renderer = AetherAPI.content().dialog().findRenderer(renderType).orElseThrow(() -> new IllegalArgumentException("Couldn't find slide renderer: " + renderType));
            renderer.setup(slide);
        }
        return renderer;
    }
}

