/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.dialog;

import com.gildedgames.aether.api.dialog.IDialogAction;
import com.gildedgames.aether.api.dialog.IDialogCondition;
import com.gildedgames.aether.api.dialog.IDialogManager;
import com.gildedgames.aether.api.dialog.IDialogScene;
import com.gildedgames.aether.api.dialog.IDialogSlide;
import com.gildedgames.aether.api.dialog.IDialogSlideRenderer;
import com.gildedgames.aether.api.dialog.IDialogSpeaker;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.dialog.data.DialogActionDeserializer;
import com.gildedgames.aether.common.dialog.data.DialogConditionDeserializer;
import com.gildedgames.aether.common.dialog.data.DialogSlideDeserializer;
import com.gildedgames.aether.common.dialog.data.DialogSlideRendererDeserializer;
import com.gildedgames.aether.common.dialog.data.actions.DialogActionExit;
import com.gildedgames.aether.common.dialog.data.actions.DialogActionNavigate;
import com.gildedgames.aether.common.dialog.data.actions.DialogActionNavigateBack;
import com.gildedgames.aether.common.dialog.data.actions.DialogActionNavigateScene;
import com.gildedgames.aether.common.dialog.data.actions.DialogActionNavigateToStart;
import com.gildedgames.aether.common.dialog.data.actions.DialogActionOpenShop;
import com.gildedgames.aether.common.dialog.data.actions.DialogActionTravelToBed;
import com.gildedgames.aether.common.dialog.data.actions.DialogActionTravelToLastOutpost;
import com.gildedgames.aether.common.dialog.data.conditions.DialogConditionHasSleptInBed;
import com.gildedgames.aether.common.dialog.data.conditions.DialogConditionIsChristmasEvent;
import com.gildedgames.aether.common.dialog.data.conditions.DialogConditionIsNewYearsEvent;
import com.gildedgames.aether.common.dialog.data.conditions.DialogConditionReturningToOutpost;
import com.gildedgames.aether.common.dialog.data.slide_renderers.DialogSlideRendererNOOP;
import com.gildedgames.aether.common.dialog.data.slide_renderers.DialogSlideRendererStatic;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DialogManager
implements IDialogManager {
    private final HashMap<ResourceLocation, IDialogScene> cachedScenes = new HashMap();
    private final HashMap<ResourceLocation, IDialogSpeaker> cachedSpeakers = new HashMap();
    private final HashMap<String, IDialogSlideRenderer> registeredRenders = new HashMap();
    private final Gson gson;
    private final boolean allowCaching;

    public DialogManager() {
        this(true);
    }

    public DialogManager(boolean allowCaching) {
        this.allowCaching = allowCaching;
        this.gson = this.buildDeserializer().create();
        this.registerRenders();
    }

    protected GsonBuilder buildDeserializer() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(IDialogAction.class, (Object)new DialogActionDeserializer());
        builder.registerTypeAdapter(IDialogCondition.class, (Object)new DialogConditionDeserializer());
        builder.registerTypeAdapter(DialogActionExit.class, (Object)new DialogActionExit.Deserializer());
        builder.registerTypeAdapter(DialogActionNavigateToStart.class, (Object)new DialogActionNavigateToStart.Deserializer());
        builder.registerTypeAdapter(DialogActionNavigateBack.class, (Object)new DialogActionNavigateBack.Deserializer());
        builder.registerTypeAdapter(DialogActionNavigate.class, (Object)new DialogActionNavigate.Deserializer());
        builder.registerTypeAdapter(DialogActionNavigateScene.class, (Object)new DialogActionNavigateScene.Deserializer());
        builder.registerTypeAdapter(DialogActionTravelToBed.class, (Object)new DialogActionTravelToBed.Deserializer());
        builder.registerTypeAdapter(DialogActionTravelToLastOutpost.class, (Object)new DialogActionTravelToLastOutpost.Deserializer());
        builder.registerTypeAdapter(DialogActionOpenShop.class, (Object)new DialogActionOpenShop.Deserializer());
        builder.registerTypeAdapter(DialogConditionReturningToOutpost.class, (Object)new DialogConditionReturningToOutpost.Deserializer());
        builder.registerTypeAdapter(DialogConditionHasSleptInBed.class, (Object)new DialogConditionHasSleptInBed.Deserializer());
        builder.registerTypeAdapter(DialogConditionIsChristmasEvent.class, (Object)new DialogConditionIsChristmasEvent.Deserializer());
        builder.registerTypeAdapter(DialogConditionIsNewYearsEvent.class, (Object)new DialogConditionIsNewYearsEvent.Deserializer());
        builder.registerTypeAdapter(IDialogSlideRenderer.class, (Object)new DialogSlideRendererDeserializer());
        builder.registerTypeAdapter(DialogSlideRendererStatic.class, (Object)new DialogSlideRendererStatic.Deserializer());
        builder.registerTypeAdapter(DialogSlideRendererNOOP.class, (Object)new DialogSlideRendererNOOP.Deserializer());
        builder.registerTypeAdapter(IDialogSlide.class, (Object)new DialogSlideDeserializer());
        return builder;
    }

    protected void registerRenders() {
        this.registeredRenders.put("static", new DialogSlideRendererStatic());
        this.registeredRenders.put("noop", new DialogSlideRendererNOOP());
    }

    @Override
    public Optional<IDialogSpeaker> getSpeaker(ResourceLocation resource) {
        IDialogSpeaker speaker;
        if (this.allowCaching && this.cachedSpeakers.containsKey(resource)) {
            return Optional.of(this.cachedSpeakers.get(resource));
        }
        try {
            speaker = this.loadSpeaker(resource);
            if (this.allowCaching) {
                this.cachedSpeakers.put(resource, speaker);
            }
        }
        catch (IOException e) {
            AetherCore.LOGGER.error("Failed to load dialog speaker: {}", (Object)resource, (Object)e);
            return Optional.empty();
        }
        return Optional.of(speaker);
    }

    @Override
    public Optional<IDialogScene> getScene(ResourceLocation resource) {
        IDialogScene scene;
        if (this.allowCaching && this.cachedScenes.containsKey(resource)) {
            return Optional.of(this.cachedScenes.get(resource));
        }
        try {
            scene = this.loadScene(resource);
            if (this.allowCaching) {
                this.cachedScenes.put(resource, scene);
            }
        }
        catch (IOException e) {
            AetherCore.LOGGER.error("Failed to load dialog scene: {}", (Object)resource, (Object)e);
            return Optional.empty();
        }
        return Optional.of(scene);
    }

    @Override
    public Optional<IDialogSlide> findSlide(String slideAddress, IDialogSpeaker speaker) {
        if (speaker == null || slideAddress == null || !speaker.getSlides().isPresent() || !speaker.getSlides().get().containsKey(slideAddress)) {
            return Optional.empty();
        }
        return Optional.of(speaker.getSlides().get().get(slideAddress));
    }

    @Override
    public Optional<IDialogSlideRenderer> findRenderer(String type) {
        if (type == null || !this.registeredRenders.containsKey(type)) {
            return Optional.empty();
        }
        return Optional.of(this.registeredRenders.get(type));
    }

    /*
     * Exception decompiling
     */
    private IDialogScene loadScene(ResourceLocation resource) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private IDialogSpeaker loadSpeaker(ResourceLocation resource) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void attachReloadListener() {
        IResourceManager resManager = Minecraft.func_71410_x().func_110442_L();
        if (resManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resManager).func_110542_a((IResourceManagerReloadListener)new ReloadListener(this));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ReloadListener
    implements IResourceManagerReloadListener {
        private final DialogManager manager;

        public ReloadListener(DialogManager manager) {
            this.manager = manager;
        }

        public void func_110549_a(IResourceManager resourceManager) {
            this.manager.cachedScenes.clear();
        }
    }
}

