/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.containers.overlays;

import com.gildedgames.aether.api.registry.tab.ITab;
import com.gildedgames.aether.api.registry.tab.ITabClient;
import com.gildedgames.aether.api.registry.tab.ITabGroup;
import com.gildedgames.aether.api.registry.tab.ITabGroupHandler;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.containers.overlays.TabGroup;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TabGroupHandler
implements ITabGroupHandler {
    public final BiMap<Integer, String> idMappings = HashBiMap.create();
    @SideOnly(value=Side.CLIENT)
    public TabGroup<ITabClient> clientGroup;
    public final TabGroup<ITab> serverGroup;
    public int discriminant;

    public TabGroupHandler() {
        if (AetherCore.isClient()) {
            this.clientGroup = new TabGroup();
        }
        this.serverGroup = new TabGroup();
    }

    @Override
    public void registerServerTab(ITab tab) {
        if (!this.idMappings.inverse().containsKey((Object)tab.getUnlocalizedName())) {
            this.idMappings.put((Object)this.discriminant++, (Object)tab.getUnlocalizedName());
        }
        this.getServerGroup().add(tab);
    }

    @Override
    public void registerClientTab(ITabClient tab) {
        if (!this.idMappings.inverse().containsKey((Object)tab.getUnlocalizedName())) {
            this.idMappings.put((Object)this.discriminant++, (Object)tab.getUnlocalizedName());
        }
        this.getClientGroup().add(tab);
    }

    @Override
    public int getDiscriminant(ITab tab) {
        return (Integer)this.idMappings.inverse().get((Object)tab.getUnlocalizedName());
    }

    @Override
    public ITabGroup<ITabClient> getClientGroup() {
        return this.clientGroup;
    }

    @Override
    public ITabGroup<ITab> getServerGroup() {
        return this.serverGroup;
    }
}

