/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.containers.inventory;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.items.equipment.ItemEquipmentSlot;
import com.gildedgames.aether.api.player.IPlayerAether;
import com.gildedgames.aether.api.player.inventory.IInventoryEquipment;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentTranslation;

public class InventoryEquipment
implements IInventoryEquipment {
    private static final ItemEquipmentSlot[] SLOT_TYPES = new ItemEquipmentSlot[]{ItemEquipmentSlot.RELIC, ItemEquipmentSlot.RELIC, ItemEquipmentSlot.HANDWEAR, ItemEquipmentSlot.RING, ItemEquipmentSlot.RING, ItemEquipmentSlot.NECKWEAR, ItemEquipmentSlot.COMPANION, ItemEquipmentSlot.ARTIFACT, ItemEquipmentSlot.CHARM, ItemEquipmentSlot.CHARM, ItemEquipmentSlot.CHARM, ItemEquipmentSlot.CHARM, ItemEquipmentSlot.CHARM, ItemEquipmentSlot.CHARM};
    private final IPlayerAether aePlayer;
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)14, (Object)ItemStack.field_190927_a);

    public InventoryEquipment(IPlayerAether aePlayer) {
        this.aePlayer = aePlayer;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.inventory.size() ? (ItemStack)this.inventory.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.inventory.set(index, (Object)ItemStack.field_190927_a);
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        this.func_70296_d();
    }

    @Override
    public int getNextEmptySlotForType(ItemEquipmentSlot type) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (!((ItemStack)this.inventory.get(i)).func_190926_b() || SLOT_TYPES[i] != type) continue;
            return i;
        }
        return -1;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !this.aePlayer.getEntity().field_70128_L && player.func_70068_e((Entity)this.aePlayer.getEntity()) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        ItemEquipmentSlot slot = AetherAPI.content().items().getProperties(stack.func_77973_b()).getEquipmentSlot();
        return slot == SLOT_TYPES[index];
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public String func_70005_c_() {
        return "inventory.accessories";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public TextComponentBase getDisplayName() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public void write(NBTTagCompound output) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound stackCompound = new NBTTagCompound();
            stackCompound.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(stackCompound);
            list.func_74742_a((NBTBase)stackCompound);
        }
        output.func_74782_a("Items", (NBTBase)list);
    }

    public void read(NBTTagCompound input) {
        NBTTagList list = input.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            int slot = compound.func_74771_c("Slot") & 0xFF;
            this.inventory.set(slot, (Object)new ItemStack(compound));
        }
    }
}

