/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.containers;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerTradeModule;
import com.gildedgames.aether.common.containers.slots.SlotDynamic;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.trade.PacketSendInventorySize;
import com.gildedgames.aether.common.network.packets.trade.PacketTradeInventory;
import com.gildedgames.aether.common.network.packets.trade.PacketTradeMessage;
import com.gildedgames.aether.common.shop.ShopCurrencyGilt;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerTrade
extends Container {
    private final InventoryBasic tradeInventory = new InventoryBasic("Trade", false, 16);
    private final InventoryPlayer playerInventory;
    private final PlayerTradeModule tradeModule;
    private final Queue<ConfirmationQueueItem> queue = new LinkedList<ConfirmationQueueItem>();
    private final boolean[][] containCheck = new boolean[4][9];
    private boolean sentError = false;

    public ContainerTrade(InventoryPlayer playerInventory) {
        int j;
        int i;
        this.playerInventory = playerInventory;
        this.tradeModule = PlayerAether.getPlayer(playerInventory.field_70458_d).getModule(PlayerTradeModule.class);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 3 + j * 18, 28 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 3 + k * 18, 86));
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                this.func_75146_a(new SlotDynamic((IInventory)this.tradeInventory, j + i * 4, 200 + j * 18, 30 + i * 18));
            }
        }
        this.updateSlotCheck(true);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.field_70170_p.field_72995_K) {
            ConfirmationQueueItem cur;
            this.func_193327_a(playerIn, playerIn.field_70170_p, (IInventory)this.tradeInventory);
            while ((cur = this.queue.poll()) != null) {
                if (!playerIn.func_70089_S() || playerIn instanceof EntityPlayerMP && ((EntityPlayerMP)playerIn).func_193105_t()) {
                    playerIn.func_71019_a(cur.item, false);
                    continue;
                }
                playerIn.field_71071_by.func_191975_a(playerIn.field_70170_p, cur.item);
            }
            if (this.tradeModule.isTrading()) {
                PlayerTradeModule otherTrade = this.tradeModule.getTarget().getModule(PlayerTradeModule.class);
                otherTrade.endTrade(this.tradeModule.getPlayer());
                this.tradeModule.setTrading(null);
            }
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack returnStack;
        if (this.tradeModule.isLockedIn() && slotId >= 36) {
            return ItemStack.field_190927_a;
        }
        if (clickTypeIn == ClickType.PICKUP && slotId == -999) {
            ItemStack stack = this.playerInventory.func_70445_o();
            if (!stack.func_190926_b()) {
                if (dragType == 0) {
                    this.queue.add(new ConfirmationQueueItem(stack, false));
                    this.playerInventory.func_70437_b(ItemStack.field_190927_a);
                }
                if (dragType == 1) {
                    this.queue.add(new ConfirmationQueueItem(stack.func_77979_a(1), false));
                }
            }
            returnStack = ItemStack.field_190927_a;
        } else if (clickTypeIn == ClickType.THROW && this.playerInventory.func_70445_o().func_190926_b() && slotId >= 0) {
            Slot slot2 = (Slot)this.field_75151_b.get(slotId);
            if (slot2 != null && slot2.func_75216_d() && slot2.func_82869_a(player)) {
                ItemStack itemStack4 = slot2.func_75209_a(dragType == 0 ? 1 : slot2.func_75211_c().func_190916_E());
                slot2.func_190901_a(player, itemStack4);
                this.queue.add(new ConfirmationQueueItem(itemStack4, false));
            }
            returnStack = ItemStack.field_190927_a;
        } else {
            ItemStack stack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
            this.updateSlotCheck(false);
            returnStack = stack;
        }
        this.compressAndSendStacks(clickTypeIn == ClickType.PICKUP_ALL || slotId >= 36);
        return returnStack;
    }

    private void compressAndSendStacks(boolean forceSend) {
        boolean change = false;
        double value = 0.0;
        for (int i = 36; i < 52; ++i) {
            ItemStack stack = this.func_75139_a(i).func_75211_c();
            value += AetherAPI.content().currency().getValue(stack, ShopCurrencyGilt.class);
            if (!this.func_75135_a(stack, 36, i, false)) continue;
            change = true;
        }
        this.tradeModule.setValue(value);
        if (change || forceSend) {
            this.sendInventory();
        }
    }

    public void updateSlotCheck(boolean forceSend) {
        int totalSlots = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 9; ++j) {
                boolean taken;
                this.containCheck[i][j] = taken = !this.playerInventory.func_70301_a(i * 9 + j).func_190926_b();
                if (taken) continue;
                ++totalSlots;
            }
        }
        if (!this.tradeModule.getWorld().field_72995_K) {
            if (totalSlots != this.tradeModule.getOpenSlots() || forceSend) {
                NetworkingAether.sendPacketToPlayer(new PacketSendInventorySize((byte)totalSlots), this.tradeModule.getTargetMP());
            }
            this.tradeModule.setOpenSlots(totalSlots);
            this.tradeModule.getTarget().getModule(PlayerTradeModule.class).setTradeSlots(totalSlots);
        }
        this.tradeModule.setOpenSlots(totalSlots);
    }

    private void sendInventory() {
        if (!this.tradeModule.getWorld().field_72995_K) {
            NetworkingAether.sendPacketToPlayer(new PacketTradeInventory((IInventory)this.tradeInventory), this.tradeModule.getTargetMP());
        }
    }

    public void updateSlots(int totalSlots) {
        boolean error = false;
        for (int i = 0; i < 16; ++i) {
            boolean enabled = i < totalSlots;
            SlotDynamic slot = (SlotDynamic)this.func_75139_a(36 + i);
            if (!enabled && slot.func_75216_d()) {
                error = true;
            }
            slot.setEnabled(enabled);
        }
        if (!this.tradeModule.getWorld().field_72995_K) {
            if (error && !this.sentError) {
                this.tradeModule.sizeError(true);
                this.tradeModule.getTarget().getModule(PlayerTradeModule.class).sizeError(true);
                NetworkingAether.sendPacketToPlayer(new PacketTradeMessage("aether.trade.message.tradewarn"), this.tradeModule.getPlayerMP());
                NetworkingAether.sendPacketToPlayer(new PacketTradeMessage("aether.trade.message.inventorywarn"), this.tradeModule.getTargetMP());
                error = true;
            } else if (!error && this.sentError) {
                this.tradeModule.sizeError(false);
                this.tradeModule.getTarget().getModule(PlayerTradeModule.class).sizeError(false);
            }
        }
        this.sentError = error;
    }

    public void addItemToQueue(ItemStack itemStack) {
        block0: for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 9; ++j) {
                ItemStack stack = this.playerInventory.func_70301_a(i * 9 + j);
                if (!stack.func_77973_b().equals(itemStack.func_77973_b()) || this.containCheck[i][j]) continue;
                this.queue.add(new ConfirmationQueueItem(stack.func_77946_l(), true));
                stack.func_190920_e(0);
                this.playerInventory.func_70296_d();
                continue block0;
            }
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return playerIn.equals((Object)this.playerInventory.field_70458_d);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d() && !this.tradeModule.isLockedIn()) {
            ItemStack itemStack1 = slot.func_75211_c();
            itemstack = itemStack1.func_77946_l();
            if (index < 36) {
                if (this.tradeModule.getTradeSlots() == 0 || !this.func_75135_a(itemStack1, 36, this.tradeModule.getTradeSlots() < 16 ? 36 + this.tradeModule.getTradeSlots() : 52, false)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemStack1, itemstack);
            } else {
                if (!this.func_75135_a(itemStack1, 0, 36, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemStack1, itemstack);
            }
            if (itemStack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemStack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemStack1);
            this.sendInventory();
        }
        return itemstack;
    }

    class ConfirmationQueueItem {
        private ItemStack item;
        private boolean pickUp;

        private ConfirmationQueueItem(ItemStack item, boolean pickUp) {
            this.item = item;
            this.pickUp = pickUp;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public boolean isPickUp() {
            return this.pickUp;
        }
    }
}

