/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.world.precipitation;

import com.gildedgames.aether.api.world.islands.precipitation.IPrecipitationManager;
import com.gildedgames.aether.api.world.islands.precipitation.PrecipitationStrength;
import com.gildedgames.aether.common.blocks.IBlockSnowy;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketUpdatePrecipitation;
import com.gildedgames.aether.common.world.biomes.BiomeAetherBase;
import com.gildedgames.aether.common.world.biomes.ISnowyBiome;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Vector2f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PrecipitationManagerImpl
implements IPrecipitationManager {
    private int updateLCG = new Random().nextInt();
    @Nonnull
    private final World world;
    private PrecipitationStrength strength = PrecipitationStrength.LIGHT;
    private Vector2f windVector = new Vector2f(0.0f, 0.0f);
    private long ticksUntilStrengthChange;
    private boolean prevIsRaining;

    public PrecipitationManagerImpl() {
        this.world = null;
    }

    public PrecipitationManagerImpl(World world) {
        this.world = world;
    }

    @Override
    public void tick() {
        if (this.world.field_72995_K) {
            return;
        }
        this.updateWeather();
        this.updateWorld();
        this.updateBlocks();
    }

    private void updateWeather() {
        WorldInfo info = this.world.func_72912_H();
        int ticksUntilRain = info.func_76083_p();
        int ticksUntilClear = info.func_176133_A();
        if (ticksUntilClear > 0) {
            info.func_176142_i(ticksUntilClear - 1);
        }
        if (ticksUntilRain > 0) {
            info.func_76080_g(ticksUntilRain - 1);
        }
        if (this.ticksUntilStrengthChange > 0L) {
            --this.ticksUntilStrengthChange;
        }
        if (info.func_76059_o() && !this.prevIsRaining) {
            this.startPrecipitation();
        } else if (!info.func_76059_o() && ticksUntilRain <= 0) {
            this.startPrecipitation();
        }
        if (info.func_76059_o()) {
            if (ticksUntilClear <= 0) {
                this.endPrecipitation();
            } else if (this.ticksUntilStrengthChange <= 0L && ticksUntilClear > 4000) {
                int rng = this.world.field_73012_v.nextInt(100);
                if (this.getStrength() != PrecipitationStrength.STORM && rng > 75) {
                    this.modifyStrength(1);
                } else if (this.getStrength() != PrecipitationStrength.LIGHT && rng > 50) {
                    this.modifyStrength(-1);
                } else {
                    this.modifyStrength(0);
                }
            }
        }
        this.prevIsRaining = info.func_76059_o();
    }

    private void updateWorld() {
        WorldInfo info = this.world.func_72912_H();
        this.world.field_73018_p = this.world.field_73017_q;
        this.world.field_73017_q = info.func_76061_m() ? (float)((double)this.world.field_73017_q + 0.01) : (float)((double)this.world.field_73017_q - 0.01);
        this.world.field_73017_q = MathHelper.func_76131_a((float)this.world.field_73017_q, (float)0.0f, (float)1.0f);
        this.world.field_73003_n = this.world.field_73004_o;
        this.world.field_73004_o = info.func_76059_o() ? (float)((double)this.world.field_73004_o + 0.01) : (float)((double)this.world.field_73004_o - 0.01);
        this.world.field_73004_o = MathHelper.func_76131_a((float)this.world.field_73004_o, (float)0.0f, (float)1.0f);
    }

    private void updateBlocks() {
        WorldInfo info = this.world.func_72912_H();
        if (!info.func_76059_o()) {
            return;
        }
        Iterator iterator = this.world.getPersistentChunkIterable(((WorldServer)this.world).func_184164_w().func_187300_b());
        while (iterator.hasNext()) {
            Chunk chunk = (Chunk)iterator.next();
            this.updateBlocksForChunk(chunk);
            this.world.field_72984_F.func_76319_b();
        }
    }

    private void updateBlocksForChunk(Chunk chunk) {
        int j = chunk.field_76635_g * 16;
        int k = chunk.field_76647_h * 16;
        if (this.world.field_73012_v.nextInt(16) == 0) {
            this.updateLCG = this.updateLCG * 3 + 1013904223;
            int j2 = this.updateLCG >> 2;
            BlockPos column = new BlockPos(j + (j2 & 0xF), 0, k + (j2 >> 8 & 0xF));
            BlockPos topBlockPos = this.world.func_175725_q(column);
            BlockPos blockPos = topBlockPos.func_177977_b();
            Biome biome = this.world.func_180494_b(column);
            if (biome instanceof ISnowyBiome) {
                ISnowyBiome snowyBiome = (ISnowyBiome)biome;
                if (this.world.func_175697_a(blockPos, 1) && this.world.func_175662_w(blockPos)) {
                    this.world.func_175656_a(blockPos, snowyBiome.getFrozenWaterBlock());
                }
                if (this.world.func_175708_f(topBlockPos, true)) {
                    this.world.func_175656_a(topBlockPos, snowyBiome.getSnowBlock());
                } else {
                    IBlockState topState = this.world.func_180495_p(topBlockPos);
                    if (topState.func_177230_c() instanceof IBlockSnowy) {
                        IBlockState newState = topState.func_177226_a((IProperty)IBlockSnowy.PROPERTY_SNOWY, (Comparable)Boolean.TRUE);
                        this.world.func_180501_a(topBlockPos, newState, 2);
                    }
                }
            }
            if (biome instanceof BiomeAetherBase && this.world.func_180494_b(blockPos).func_76738_d()) {
                this.world.func_180495_p(blockPos).func_177230_c().func_176224_k(this.world, blockPos);
            }
        }
    }

    private void startPrecipitation() {
        int duration = this.world.field_73012_v.nextInt(20000) + 10000;
        this.strength = PrecipitationStrength.VALUES[this.world.field_73012_v.nextInt(PrecipitationStrength.VALUES.length)];
        this.windVector.x = (this.world.field_73012_v.nextFloat() * 2.0f - 1.0f) * 1.2f;
        this.windVector.y = (this.world.field_73012_v.nextFloat() * 2.0f - 1.0f) * 1.2f;
        WorldInfo info = this.world.func_72912_H();
        info.func_76084_b(true);
        info.func_176142_i(duration);
        this.sendUpdates();
    }

    private void endPrecipitation() {
        int duration = this.world.field_73012_v.nextInt(20000) + 6000;
        this.strength = PrecipitationStrength.LIGHT;
        WorldInfo info = this.world.func_72912_H();
        info.func_76084_b(false);
        info.func_76080_g(duration);
        this.sendUpdates();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getSkyDarkness() {
        switch (this.getStrength()) {
            case LIGHT: {
                return 0.15f;
            }
            case HEAVY: {
                return 0.3f;
            }
            case STORM: {
                return 0.6f;
            }
        }
        return 0.0f;
    }

    private void modifyStrength(int mod) {
        this.strength = PrecipitationStrength.VALUES[(this.strength.ordinal() + mod) % PrecipitationStrength.VALUES.length];
        this.ticksUntilStrengthChange = this.world.field_73012_v.nextInt(2000) + 1000;
        this.sendUpdates();
    }

    private void sendUpdates() {
        if (!this.world.field_72995_K) {
            NetworkingAether.sendPacketToDimension(new PacketUpdatePrecipitation(this), this.world.field_73011_w.getDimension());
        }
    }

    @Override
    public PrecipitationStrength getStrength() {
        return this.strength;
    }

    @Override
    public Vector2f getWindVector() {
        return this.windVector;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Strength", this.strength.name());
        tag.func_74772_a("TicksUntilStrengthChange", this.ticksUntilStrengthChange);
        tag.func_74776_a("WindX", this.windVector.x);
        tag.func_74776_a("WindY", this.windVector.y);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.strength = PrecipitationStrength.lookup(nbt.func_74779_i("Strength"));
        this.ticksUntilStrengthChange = nbt.func_74763_f("TicksUntilStrengthChange");
        this.windVector = new Vector2f(nbt.func_74760_g("WindX"), nbt.func_74760_g("WindY"));
    }

    public static class Storage
    implements Capability.IStorage<IPrecipitationManager> {
        @Nullable
        public NBTBase writeNBT(Capability<IPrecipitationManager> capability, IPrecipitationManager instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IPrecipitationManager> capability, IPrecipitationManager instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
        }
    }
}

