/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.world.chunk;

import com.gildedgames.aether.api.chunk.IPlacementFlagCapability;
import java.util.BitSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;

public class PlacementFlagCapability
implements IPlacementFlagCapability {
    private static final int CHUNK_SIZE = 65536;
    private BitSet bits = new BitSet(65536);

    @Override
    public void markModified(BlockPos pos) {
        this.set(pos, true);
    }

    @Override
    public void clearModified(BlockPos pos) {
        this.set(pos, false);
    }

    private void set(BlockPos pos, boolean value) {
        this.bits.set(this.getIndexFromCoordinate(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF), value);
    }

    @Override
    public boolean isModified(BlockPos pos) {
        return this.bits.get(this.getIndexFromCoordinate(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF));
    }

    public void write(NBTTagCompound output) {
        output.func_74773_a("bits", this.bits.toByteArray());
    }

    public void read(NBTTagCompound input) {
        if (input.func_74764_b("bits")) {
            this.bits = BitSet.valueOf(input.func_74770_j("bits"));
        }
    }

    private int getIndexFromCoordinate(int x, int y, int z) {
        return x * 256 * 16 + y * 16 + z;
    }

    public static class Storage
    implements Capability.IStorage<IPlacementFlagCapability> {
        public NBTBase writeNBT(Capability<IPlacementFlagCapability> capability, IPlacementFlagCapability instance, EnumFacing side) {
            NBTTagCompound out = new NBTTagCompound();
            instance.write(out);
            return out;
        }

        public void readNBT(Capability<IPlacementFlagCapability> capability, IPlacementFlagCapability instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound input = (NBTTagCompound)nbt;
            instance.read(input);
        }
    }
}

