/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.item.effects.stats;

import com.gildedgames.aether.api.items.equipment.effects.EffectHelper;
import com.gildedgames.aether.api.items.equipment.effects.EffectInstance;
import com.gildedgames.aether.api.items.equipment.effects.IEffectFactory;
import com.gildedgames.aether.api.items.equipment.effects.IEffectPool;
import com.gildedgames.aether.api.items.equipment.effects.IEffectProvider;
import com.gildedgames.aether.api.player.IPlayerAether;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.text.DecimalFormat;
import java.util.Collection;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class StatEffectFactory
implements IEffectFactory<StatProvider> {
    private static final ResourceLocation NAME = new ResourceLocation("aether", "stat_provider");
    private static final DecimalFormat POINT_FORMATTER = new DecimalFormat("#.#");

    @Override
    public EffectInstance createInstance(IEffectPool<StatProvider> pool) {
        return new StatInstance(pool.getActiveProviders());
    }

    @Override
    public ResourceLocation getIdentifier() {
        return NAME;
    }

    public static class StatInstance
    extends EffectInstance {
        private final Multimap<String, AttributeModifier> attributes = MultimapBuilder.hashKeys().arrayListValues().build();

        public StatInstance(Collection<StatProvider> providers) {
            for (StatProvider provider : providers) {
                AttributeModifier modifier = new AttributeModifier("Equipment modifier", provider.amount, provider.opcode);
                modifier.func_111168_a(false);
                this.attributes.put((Object)provider.attribute.func_111108_a(), (Object)modifier);
            }
        }

        @Override
        public void onInstanceRemoved(IPlayerAether player) {
            player.getEntity().func_110140_aT().func_111148_a(this.attributes);
        }

        @Override
        public void onInstanceAdded(IPlayerAether player) {
            player.getEntity().func_110140_aT().func_111147_b(this.attributes);
        }

        @Override
        public void addInformation(Collection<String> label, TextFormatting format1, TextFormatting format2) {
            for (String name : this.attributes.keySet()) {
                ListMultimap mods = MultimapBuilder.hashKeys().arrayListValues().build();
                for (AttributeModifier mod : this.attributes.get((Object)name)) {
                    mods.put((Object)mod.func_111169_c(), (Object)mod);
                }
                for (Integer opcode : mods.keySet()) {
                    String prefix;
                    double value = EffectHelper.combineDouble(mods.get((Object)opcode), AttributeModifier::func_111164_d);
                    String string = prefix = value > 0.0 ? format1 + " +" : format2 + " -";
                    if (format1 == TextFormatting.GRAY && format2 == TextFormatting.GRAY) {
                        prefix = value > 0.0 ? format1 + " " : format2 + " ";
                    }
                    String desc = I18n.func_135052_a((String)("attribute.name." + name), (Object[])new Object[0]);
                    if (opcode == 1) {
                        label.add(prefix + POINT_FORMATTER.format(Math.abs(value) * 100.0) + "% " + desc);
                        continue;
                    }
                    label.add(prefix + POINT_FORMATTER.format(Math.abs(value)) + " " + desc);
                }
            }
        }
    }

    public static class StatProvider
    implements IEffectProvider {
        public static final int OP_ADD = 0;
        public static final int OP_MULTIPLY = 1;
        private final IAttribute attribute;
        private final double amount;
        private final int opcode;

        public StatProvider(IAttribute attribute, double amount, int opcode) {
            this.attribute = attribute;
            this.amount = amount;
            this.opcode = opcode;
        }

        @Override
        public ResourceLocation getFactory() {
            return NAME;
        }

        @Override
        public IEffectProvider copy() {
            return new StatProvider(this.attribute, this.amount, this.opcode);
        }
    }
}

