/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.item.effects;

import com.gildedgames.aether.api.items.equipment.effects.EffectHelper;
import com.gildedgames.aether.api.items.equipment.effects.EffectInstance;
import com.gildedgames.aether.api.items.equipment.effects.IEffectFactory;
import com.gildedgames.aether.api.items.equipment.effects.IEffectPool;
import com.gildedgames.aether.api.items.equipment.effects.IEffectProvider;
import com.gildedgames.aether.api.player.IPlayerAether;
import java.text.DecimalFormat;
import java.util.Collection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class RegenerationEffectFactory
implements IEffectFactory<Provider> {
    private static final DecimalFormat FORMATTER = new DecimalFormat("#.##");
    private static final ResourceLocation NAME = new ResourceLocation("aether", "regeneration");

    @Override
    public EffectInstance createInstance(IEffectPool<Provider> pool) {
        RegenerationEffectInstance state = new RegenerationEffectInstance();
        state.healAmount = EffectHelper.combineInt(pool.getActiveProviders(), instance -> ((Provider)instance).heal);
        return state;
    }

    @Override
    public ResourceLocation getIdentifier() {
        return NAME;
    }

    private class RegenerationEffectInstance
    extends EffectInstance {
        private int healAmount;
        private int ticksUntilHeal = 120;

        private RegenerationEffectInstance() {
        }

        @Override
        public void onEntityUpdate(IPlayerAether player) {
            if (player.getEntity().field_70737_aN > 0) {
                this.ticksUntilHeal = 120;
                return;
            }
            if (this.ticksUntilHeal <= 0) {
                player.getEntity().func_70691_i((float)this.healAmount);
                this.ticksUntilHeal = 20;
            }
            --this.ticksUntilHeal;
        }

        @Override
        public void addInformation(Collection<String> label, TextFormatting format1, TextFormatting format2) {
            label.add(TextFormatting.RED.toString() + TextFormatting.ITALIC.toString() + "+" + FORMATTER.format(this.healAmount) + " Regeneration per Second");
        }
    }

    public static class Provider
    implements IEffectProvider {
        private final int heal;

        public Provider(int heal) {
            this.heal = heal;
        }

        @Override
        public ResourceLocation getFactory() {
            return NAME;
        }

        @Override
        public IEffectProvider copy() {
            return new Provider(this.heal);
        }
    }
}

