/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.item.effects;

import com.gildedgames.aether.api.items.equipment.effects.EffectInstance;
import com.gildedgames.aether.api.items.equipment.effects.IEffectFactory;
import com.gildedgames.aether.api.items.equipment.effects.IEffectPool;
import com.gildedgames.aether.api.items.equipment.effects.IEffectProvider;
import com.gildedgames.aether.api.player.IPlayerAether;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class PotionEffectFactory
implements IEffectFactory<PotionEffectProvider> {
    private static final ResourceLocation NAME = new ResourceLocation("aether", "potion_effect");

    @Override
    public EffectInstance createInstance(IEffectPool<PotionEffectProvider> pool) {
        return new PotionEffectInstance(pool.getActiveProviders());
    }

    @Override
    public ResourceLocation getIdentifier() {
        return NAME;
    }

    private class PotionEffectInstance
    extends EffectInstance {
        private final Collection<PotionEffectProvider> potions;
        private int ticksExisted = 0;

        public PotionEffectInstance(Collection<PotionEffectProvider> providers) {
            this.potions = new ArrayList<PotionEffectProvider>(providers);
        }

        @Override
        public void onEntityUpdate(IPlayerAether player) {
            ++this.ticksExisted;
            if (this.ticksExisted % 200 == 0) {
                this.addPotions(player);
            }
        }

        @Override
        public void onInstanceRemoved(IPlayerAether player) {
            this.potions.stream().map(provider -> ((PotionEffectProvider)provider).potion).forEach(arg_0 -> ((EntityPlayer)player.getEntity()).func_184589_d(arg_0));
        }

        @Override
        public void onInstanceAdded(IPlayerAether player) {
            this.addPotions(player);
        }

        private void addPotions(IPlayerAether player) {
            this.potions.stream().map(provider -> new PotionEffect(((PotionEffectProvider)provider).potion, 1000, ((PotionEffectProvider)provider).strength, true, false)).forEach(arg_0 -> ((EntityPlayer)player.getEntity()).func_70690_d(arg_0));
        }

        @Override
        public void addInformation(Collection<String> label, TextFormatting format1, TextFormatting format2) {
            this.potions.stream().map(provider -> ((PotionEffectProvider)provider).potion.func_76393_a()).collect(Collectors.toSet()).forEach(name -> label.add(TextFormatting.BLUE + "Gives " + I18n.func_135052_a((String)name, (Object[])new Object[0])));
        }
    }

    public static class PotionEffectProvider
    implements IEffectProvider {
        private final Potion potion;
        private final int strength;

        public PotionEffectProvider(Potion potion, int strength) {
            this.potion = potion;
            this.strength = strength;
        }

        @Override
        public ResourceLocation getFactory() {
            return NAME;
        }

        @Override
        public IEffectProvider copy() {
            return new PotionEffectProvider(this.potion, this.strength);
        }
    }
}

