/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.item.effects;

import com.gildedgames.aether.api.items.equipment.effects.EffectInstance;
import com.gildedgames.aether.api.items.equipment.effects.IEffectFactory;
import com.gildedgames.aether.api.items.equipment.effects.IEffectPool;
import com.gildedgames.aether.api.items.equipment.effects.IEffectProvider;
import com.gildedgames.aether.api.player.IPlayerAether;
import com.gildedgames.aether.common.entities.companions.EntityCompanion;
import com.gildedgames.aether.common.entities.companions.EntityEtherealWisp;
import com.gildedgames.aether.common.items.companions.ItemCompanion;
import com.gildedgames.aether.common.world.spawning.SpawnHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;

public class CompanionEffectFactory
implements IEffectFactory<CompanionEffectProvider> {
    private static final ResourceLocation NAME = new ResourceLocation("aether", "companion_effect");

    @Override
    public EffectInstance createInstance(IEffectPool<CompanionEffectProvider> pool) {
        return new CompanionEffectInstance(pool);
    }

    @Override
    public ResourceLocation getIdentifier() {
        return NAME;
    }

    private class CompanionEffectInstance
    extends EffectInstance {
        private final IEffectPool<CompanionEffectProvider> pool;
        private final HashMap<CompanionEffectProvider, EntityCompanion> entities;

        public CompanionEffectInstance(IEffectPool<CompanionEffectProvider> pool) {
            this.pool = pool;
            this.entities = new HashMap();
        }

        @Override
        public void onEntityUpdate(IPlayerAether player) {
            this.entities.forEach((provider, companion) -> {
                ItemStack stack;
                if (companion.field_70128_L && !companion.wasDespawned() && (stack = this.pool.getProvider((CompanionEffectProvider)provider)).func_77973_b() instanceof ItemCompanion) {
                    ItemCompanion.setRespawnTimer(stack, companion.field_70170_p, 3600);
                }
            });
        }

        @Override
        public void onInstanceAdded(IPlayerAether player) {
            this.pool.getActiveProviders().forEach(provider -> this.spawnCompanion(player, (CompanionEffectProvider)provider));
        }

        private void spawnCompanion(IPlayerAether player, CompanionEffectProvider provider) {
            ItemStack stack = this.pool.getProvider(provider);
            EntityCompanion companion = (EntityCompanion)EntityList.func_188429_b((ResourceLocation)provider.name, (World)player.getEntity().func_130014_f_());
            Validate.notNull((Object)((Object)companion), (String)"Failed to create companion entity", (Object[])new Object[0]);
            companion.setOwner(player.getEntity());
            if (stack.func_82837_s()) {
                companion.func_96094_a(stack.func_82833_r());
            }
            this.attemptCompanionPlacement(player, companion);
            player.getEntity().func_130014_f_().func_72838_d((Entity)companion);
            this.entities.put(provider, companion);
        }

        @Override
        public void onInstanceRemoved(IPlayerAether player) {
            for (EntityCompanion companion : this.entities.values()) {
                companion.setOwner(null);
                companion.setDespawned(true);
                companion.func_70106_y();
                if (!(companion instanceof EntityEtherealWisp)) continue;
                EntityPlayer p = player.getEntity();
                p.func_82142_c(false);
            }
            this.entities.clear();
        }

        private void attemptCompanionPlacement(IPlayerAether player, EntityCompanion companion) {
            BlockPos origin = player.getEntity().func_180425_c();
            Random rand = companion.func_70681_au();
            for (int attempts = 0; attempts < 20; ++attempts) {
                double xOffset = -1.5 + rand.nextDouble() * 3.0;
                double zOffset = -1.5 + rand.nextDouble() * 3.0;
                companion.func_70107_b((double)origin.func_177958_n() + xOffset, origin.func_177956_o(), (double)origin.func_177952_p() + zOffset);
                if (!companion.func_130014_f_().func_180495_p(companion.func_180425_c().func_177977_b()).func_185913_b() || !SpawnHandler.isNotColliding(EntityLiving.SpawnPlacementType.ON_GROUND, companion.func_130014_f_(), (Entity)companion)) continue;
                companion.func_130014_f_().func_72866_a((Entity)companion, true);
                return;
            }
            companion.func_70634_a(player.getEntity().field_70165_t, player.getEntity().field_70163_u, player.getEntity().field_70161_v);
            companion.func_130014_f_().func_72866_a((Entity)companion, true);
        }

        @Override
        public void addInformation(Collection<String> label, TextFormatting color1, TextFormatting color2) {
        }
    }

    public static class CompanionEffectProvider
    implements IEffectProvider {
        private final ResourceLocation name;

        public CompanionEffectProvider(Class<? extends EntityCompanion> clazz) {
            this(EntityList.func_191306_a(clazz));
        }

        public CompanionEffectProvider(ResourceLocation id) {
            Validate.notNull((Object)id, (String)"Entity resource name is null", (Object[])new Object[0]);
            this.name = id;
        }

        @Override
        public ResourceLocation getFactory() {
            return NAME;
        }

        @Override
        public IEffectProvider copy() {
            return new CompanionEffectProvider(this.name);
        }
    }
}

