/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player.modules;

import com.gildedgames.aether.api.player.IPlayerAether;
import com.gildedgames.aether.client.gui.dialog.GuiTrade;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAetherModule;
import com.gildedgames.aether.common.containers.ContainerTrade;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketCloseScreen;
import com.gildedgames.aether.common.network.packets.trade.PacketTradeInitial;
import com.gildedgames.aether.common.network.packets.trade.PacketTradeState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerTradeModule
extends PlayerAetherModule {
    private IPlayerAether target;
    private int requestedTime;
    private int failTime;
    private int openSlots;
    private int tradeSlots;
    private boolean isTrading;
    private boolean lockedIn;
    private boolean confirmed;
    private boolean error;
    private double coinCount;
    private double tradeValue;
    private Vec3i requestPosition;

    public PlayerTradeModule(PlayerAether playerAether) {
        super(playerAether);
    }

    @Override
    public void tickStart(TickEvent.PlayerTickEvent event) {
        if (this.requestedTime > 0) {
            --this.requestedTime;
            if (!this.getWorld().field_72995_K && this.requestedTime == 0 && this.target != null) {
                TextComponentTranslation message = new TextComponentTranslation("aether.trade.chat.failexpired", new Object[]{this.target.getEntity().func_145748_c_().func_150254_d()});
                message.func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150217_b(Boolean.valueOf(true)));
                this.getEntity().func_145747_a((ITextComponent)message);
            }
        }
        if (this.failTime > 0) {
            --this.failTime;
        }
    }

    public IPlayerAether getTarget() {
        return this.target;
    }

    public boolean isTrading() {
        return this.isTrading && this.target != null && this.getPlayer().equals(this.target.getModule(PlayerTradeModule.class).target);
    }

    public void setConfirmed(boolean confirmed) {
        if (this.getWorld().field_72995_K) {
            NetworkingAether.sendPacketToServer(new PacketTradeState(2));
        } else {
            this.confirmed = confirmed;
            this.sendState(3);
        }
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setLockedIn(boolean lockedIn) {
        this.lockedIn = lockedIn;
        this.confirmed = false;
        if (this.getWorld().field_72995_K) {
            NetworkingAether.sendPacketToServer(new PacketTradeState((byte)(!this.lockedIn ? 1 : 0)));
        } else {
            this.sendState(0);
        }
    }

    public boolean isLockedIn() {
        return this.lockedIn;
    }

    public boolean canAccept(BlockPos pos) {
        return !this.isTrading && this.requestPosition.func_177951_i((Vec3i)pos) < 100.0 && this.requestedTime > 0;
    }

    public void sendState(int state) {
        if (!this.getWorld().field_72995_K) {
            PlayerTradeModule targetTrade = this.target.getModule(PlayerTradeModule.class);
            if (this.error) {
                state = -1;
                this.lockedIn = false;
                this.confirmed = false;
            } else if (state == 0) {
                if (targetTrade.isLockedIn()) {
                    ++state;
                }
                if (this.lockedIn) {
                    state += 2;
                }
            } else if (state == 3) {
                if (targetTrade.isConfirmed()) {
                    ++state;
                }
                if (this.confirmed) {
                    state += 2;
                }
            }
            NetworkingAether.sendPacketToPlayer(new PacketTradeState((byte)state), this.getPlayerMP());
        }
    }

    public void request(IPlayerAether other) {
        this.target = other;
        this.requestedTime = 400;
        this.requestPosition = this.getEntity().func_180425_c();
        TextComponentTranslation message = new TextComponentTranslation("aether.trade.chat.request", new Object[]{this.getEntity().func_145748_c_().func_150254_d()});
        message.func_150255_a(new Style().func_150238_a(TextFormatting.AQUA).func_150217_b(Boolean.valueOf(true)));
        other.getEntity().func_145747_a((ITextComponent)message);
    }

    public void clear() {
        this.failTime = 0;
        this.requestedTime = 0;
        this.coinCount = 0.0;
        this.confirmed = false;
        this.lockedIn = false;
    }

    public void accept() {
        this.isTrading = true;
        this.clear();
        this.openGui();
    }

    public void setTrading(PlayerTradeModule other) {
        this.clear();
        if (other == null) {
            this.isTrading = false;
            this.target = null;
        } else {
            this.isTrading = true;
            this.target = other.getPlayer();
            this.openGui();
        }
    }

    private void openGui() {
        BlockPos pos = this.getEntity().func_180425_c();
        this.getEntity().openGui((Object)"aether", 14, this.getWorld(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        NetworkingAether.sendPacketToPlayer(new PacketTradeInitial(this.target.getEntity().func_145782_y()), this.getPlayerMP());
    }

    public void closeGui() {
        NetworkingAether.sendPacketToPlayer(new PacketCloseScreen(14), (EntityPlayerMP)this.getEntity());
    }

    public boolean canRequest() {
        return this.requestedTime == 0;
    }

    public int getFailTime() {
        return this.failTime;
    }

    public void failRequest(PlayerTradeModule other) {
        TextComponentTranslation message = new TextComponentTranslation("aether.trade.chat.fail" + (other.isTrading() ? "trade" : "sent"), new Object[]{other.getEntity().func_145748_c_().func_150254_d()});
        message.func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150217_b(Boolean.valueOf(true)));
        this.getEntity().func_145747_a((ITextComponent)message);
        this.failTime = 30;
    }

    public void endTrade(IPlayerAether aePlayer) {
        if (this.isTrading() && aePlayer.equals(this.getTarget())) {
            this.setTrading(null);
            if (!this.getWorld().field_72995_K) {
                EntityPlayerMP entityPlayerMP = (EntityPlayerMP)this.getPlayer().getEntity();
                entityPlayerMP.func_71128_l();
                NetworkingAether.sendPacketToPlayer(new PacketCloseScreen(14), entityPlayerMP);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateClientState(int state) {
        Minecraft mc = Minecraft.func_71410_x();
        boolean bl = this.lockedIn = state >= 2;
        if (mc.field_71462_r instanceof GuiTrade) {
            GuiTrade tradeGui = (GuiTrade)mc.field_71462_r;
            tradeGui.setTradeState(state);
        }
    }

    public int getTradeSlots() {
        return this.tradeSlots;
    }

    public void setTradeSlots(int size) {
        this.tradeSlots = size;
        if (this.getWorld().field_72995_K) {
            this.setTradeSlotsClient(size);
        } else if (this.getEntity().field_71070_bA instanceof ContainerTrade) {
            ContainerTrade tradeContainer = (ContainerTrade)this.getEntity().field_71070_bA;
            tradeContainer.updateSlots(size);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void setTradeSlotsClient(int size) {
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen instanceof GuiTrade) {
            ContainerTrade tradeContainer = (ContainerTrade)((GuiTrade)currentScreen).field_147002_h;
            tradeContainer.updateSlots(size);
        }
    }

    public EntityPlayerMP getPlayerMP() {
        return (EntityPlayerMP)this.getEntity();
    }

    public EntityPlayerMP getTargetMP() {
        return (EntityPlayerMP)this.getTarget().getEntity();
    }

    public int getOpenSlots() {
        return this.openSlots;
    }

    public void setOpenSlots(int openSlots) {
        this.openSlots = openSlots;
    }

    public void setTarget(PlayerAether playerAether) {
        this.target = playerAether;
    }

    public void sizeError(boolean error) {
        this.error = error;
        this.sendState(0);
    }

    public void setCoinAmount(double coinCount) {
        this.coinCount = coinCount;
    }

    public double getCoinAmount() {
        return this.coinCount;
    }

    public void setValue(double value) {
        this.tradeValue = value;
    }

    public double getValue() {
        return this.tradeValue;
    }
}

