/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player.modules;

import com.gildedgames.aether.api.player.IPlayerAetherModule;
import com.gildedgames.aether.api.registrar.SoundsAether;
import com.gildedgames.aether.client.events.listeners.gui.GuiLoadingListener;
import com.gildedgames.aether.client.gui.misc.GuiIntro;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.ConfigAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAetherModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerConfigModule;
import com.gildedgames.aether.common.events.PostAetherTravelEvent;
import com.gildedgames.aether.common.init.DimensionsAether;
import com.gildedgames.aether.common.init.InstancesAether;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketSetPlayedIntro;
import com.gildedgames.aether.common.util.helpers.IslandHelper;
import com.gildedgames.aether.common.world.instances.necromancer_tower.NecromancerTowerInstanceHelper;
import com.gildedgames.orbis.lib.OrbisLib;
import com.gildedgames.orbis.lib.util.TeleporterGeneric;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.BlockPosDimension;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.gildedgames.orbis.lib.world.instances.IInstance;
import com.gildedgames.orbis.lib.world.instances.IPlayerInstances;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerTeleportingModule
extends PlayerAetherModule
implements IPlayerAetherModule.Serializable {
    public static final int TELEPORT_DELAY = 80;
    private boolean isTeleportCharging;
    private BlockPosDimension nonAetherPos;
    private BlockPosDimension aetherPos;
    private boolean playedIntro;
    private float lastPercent;
    private int ticksInTeleporter;
    private int prevTicksInTeleporter;

    public PlayerTeleportingModule(PlayerAether playerAether) {
        super(playerAether);
    }

    public BlockPosDimension getNonAetherPos() {
        return this.nonAetherPos;
    }

    public void setNonAetherPos(BlockPosDimension pos) {
        this.nonAetherPos = pos;
    }

    public BlockPosDimension getAetherPos() {
        return this.aetherPos;
    }

    public void setAetherPos(BlockPosDimension pos) {
        this.aetherPos = pos;
    }

    public boolean hasPlayedIntro() {
        return this.playedIntro;
    }

    public void setPlayedIntro(boolean playedIntro) {
        this.playedIntro = playedIntro;
    }

    public int getTicksInTeleporter() {
        return this.ticksInTeleporter;
    }

    public int getPrevTicksInTeleporter() {
        return this.prevTicksInTeleporter;
    }

    @SideOnly(value=Side.CLIENT)
    private void onUpdateClient() {
        if (this.getWorld().field_73011_w.func_186058_p() == DimensionsAether.NECROMANCER_TOWER && !this.playedIntro && Minecraft.func_71410_x().field_71462_r == null) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiIntro());
        }
    }

    public float getLastPercent() {
        return this.lastPercent;
    }

    public void setLastPercent(float lastPercent) {
        this.lastPercent = lastPercent;
    }

    @Override
    public void tickStart(TickEvent.PlayerTickEvent event) {
        this.isTeleportCharging = false;
    }

    @Override
    public void tickEnd(TickEvent.PlayerTickEvent event) {
        if (this.getWorld().field_72995_K) {
            this.onUpdateClient();
        }
        this.prevTicksInTeleporter = this.ticksInTeleporter++;
        if (this.isTeleportCharging && this.getEntity().func_130014_f_().field_73011_w.func_186058_p() != DimensionsAether.NECROMANCER_TOWER && this.getEntity().func_130014_f_().field_73011_w.func_186058_p() != DimensionsAether.AETHER) {
            if (this.getEntity().field_71088_bW > 0) {
                this.getEntity().field_71088_bW = this.getEntity().func_82147_ab();
            } else if (this.ticksInTeleporter == 1) {
                if (this.getWorld().field_72995_K && Minecraft.func_71410_x().field_71439_g.func_145782_y() == this.getEntity().func_145782_y()) {
                    Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsAether.glowstone_portal_trigger, 1.0f, 1.0f);
                }
            } else if (!this.getWorld().field_72995_K && (this.getTicksInTeleporter() >= 80 || this.getEntity().func_184812_l_())) {
                this.ticksInTeleporter = 0;
                this.teleportToTower();
            }
        } else if (this.isTeleportCharging && this.getEntity().func_130014_f_().field_73011_w.func_186058_p() == DimensionsAether.NECROMANCER_TOWER) {
            if (this.getEntity().field_71088_bW > 0) {
                this.getEntity().field_71088_bW = this.getEntity().func_82147_ab();
            } else {
                ++this.ticksInTeleporter;
                if (this.ticksInTeleporter == 1) {
                    if (this.getWorld().field_72995_K && Minecraft.func_71410_x().field_71439_g.func_145782_y() == this.getEntity().func_145782_y()) {
                        Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsAether.glowstone_portal_trigger, 1.0f, 1.0f);
                    }
                } else if (!this.getWorld().field_72995_K && (this.getTicksInTeleporter() >= 80 || this.getEntity().func_184812_l_())) {
                    this.ticksInTeleporter = 0;
                    this.teleportToAether();
                }
            }
        } else {
            this.ticksInTeleporter -= 4;
        }
        this.ticksInTeleporter = MathHelper.func_76125_a((int)this.ticksInTeleporter, (int)0, (int)80);
    }

    public void processTeleporting() {
        this.isTeleportCharging = true;
    }

    public void teleportToTower() {
        EntityPlayer player = this.getEntity();
        PlayerAether playerAether = PlayerAether.getPlayer(player);
        World world = this.getEntity().func_130014_f_();
        NecromancerTowerInstanceHelper handler = InstancesAether.NECROMANCER_TOWER_HANDLER;
        PlayerTeleportingModule teleportingModule = playerAether.getModule(PlayerTeleportingModule.class);
        IPlayerInstances hook = OrbisLib.instances().getPlayer(player);
        if (world.field_72995_K) {
            if (ConfigAether.skipIntro) {
                teleportingModule.setPlayedIntro(true);
                NetworkingAether.sendPacketToServer(new PacketSetPlayedIntro(true));
            }
            if (!teleportingModule.hasPlayedIntro()) {
                GuiLoadingListener.setDrawBlackScreen(true);
            } else {
                GuiLoadingListener.setDrawLoading(true);
            }
        } else if (teleportingModule.getAetherPos() != null) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            BlockPosDimension p = teleportingModule.getAetherPos();
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (ForgeHooks.onTravelToDimension((Entity)playerMP, (int)p.getDim())) {
                TeleporterGeneric teleporter = new TeleporterGeneric(server.func_71218_a(player.field_71093_bK));
                PlayerList playerList = server.func_184103_al();
                playerList.transferPlayerToDimension(playerMP, p.getDim(), (Teleporter)teleporter);
                player.field_71088_bW = player.func_82147_ab();
                playerMP.field_71135_a.func_147364_a((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), 225.0f, 0.0f);
                PostAetherTravelEvent event = new PostAetherTravelEvent((Entity)playerMP);
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
        } else if (hook.getInstance() != null) {
            IInstance instance = hook.getInstance();
            if (player.field_71093_bK == instance.getDimensionId()) {
                handler.teleportBack((EntityPlayerMP)player);
            } else {
                hook.setInstance(null);
                handler.teleportToInst((EntityPlayerMP)player);
            }
        } else if (playerAether.getModule(PlayerConfigModule.class).skipIntro()) {
            teleportingModule.teleportToAether();
        } else {
            handler.teleportToInst((EntityPlayerMP)player);
        }
    }

    public void teleportToAether() {
        this.getEntity().field_71088_bW = this.getEntity().func_82147_ab();
        if (this.getEntity().field_70170_p.field_72995_K && Minecraft.func_71410_x().field_71439_g.func_145782_y() == this.getEntity().func_145782_y()) {
            Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundsAether.glowstone_portal_travel, 1.0f, 1.0f);
        }
        if (this.getEntity().field_70170_p instanceof WorldServer) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            WorldServer worldServer = server.func_71218_a(this.getEntity().field_71093_bK);
            EntityPlayer player = this.getEntity();
            int transferToID = ConfigAether.aetherDimID;
            AetherCore.PROXY.teleportEntity((Entity)this.getEntity(), worldServer, (Teleporter)new TeleporterGeneric(worldServer), transferToID, () -> {
                PlayerAether playerAether = PlayerAether.getPlayer(player);
                PlayerTeleportingModule teleportingModule = playerAether.getModule(PlayerTeleportingModule.class);
                if (teleportingModule.getAetherPos() == null) {
                    BlockPos pos = new BlockPos(100, 0, 100);
                    BlockPos respawn = IslandHelper.getOutpostPos(player.field_70170_p, pos);
                    teleportingModule.setAetherPos(new BlockPosDimension(respawn.func_177958_n(), respawn.func_177956_o(), respawn.func_177952_p(), ConfigAether.aetherDimID));
                }
                return teleportingModule.getAetherPos();
            });
        }
    }

    public void write(NBTTagCompound output) {
        NBTFunnel funnel = new NBTFunnel(output);
        funnel.set("nonAetherPos", (NBT)this.nonAetherPos);
        funnel.set("aetherPos", (NBT)this.aetherPos);
        output.func_74757_a("playedIntro", this.playedIntro);
    }

    public void read(NBTTagCompound input) {
        NBTFunnel funnel = new NBTFunnel(input);
        this.nonAetherPos = (BlockPosDimension)funnel.get("nonAetherPos");
        if (this.nonAetherPos != null && this.nonAetherPos.getDim() == DimensionsAether.AETHER.func_186068_a()) {
            this.nonAetherPos = null;
        }
        this.aetherPos = (BlockPosDimension)funnel.get("aetherPos");
        this.playedIntro = input.func_74767_n("playedIntro");
    }

    @Override
    public ResourceLocation getIdentifier() {
        return AetherCore.getResource("teleport");
    }
}

