/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player.modules;

import com.gildedgames.aether.api.player.IPlayerAetherModule;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAetherModule;
import com.gildedgames.aether.common.entities.monsters.EntitySwet;
import com.gildedgames.aether.common.util.helpers.EntityUtil;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerSwetTrackerModule
extends PlayerAetherModule
implements IPlayerAetherModule.Serializable {
    public static final int MAX_SWET_COUNT = 3;
    private final List<EntitySwet> swets = Lists.newArrayList();

    public PlayerSwetTrackerModule(PlayerAether playerAether) {
        super(playerAether);
    }

    public List<EntitySwet> getLatchedSwets() {
        return this.swets;
    }

    public void detachSwets() {
        if (!this.getEntity().field_70170_p.field_72995_K) {
            for (EntitySwet swet : this.swets) {
                swet.setFoodSaturation(0);
                this.spawnSwet(swet);
            }
        }
        this.swets.clear();
    }

    public void detachSwet(EntitySwet swet) {
        this.swets.remove(swet);
        this.spawnSwet(swet);
    }

    public void spawnSwet(EntitySwet swet) {
        if (!this.getEntity().field_70170_p.field_72995_K) {
            swet.func_70107_b(this.getEntity().field_70165_t, this.getEntity().field_70163_u, this.getEntity().field_70161_v);
            this.getEntity().field_70170_p.func_72838_d((Entity)swet);
        }
    }

    public boolean canLatchOn() {
        return this.swets.size() < 3;
    }

    public void latchSwet(EntitySwet swet) {
        if (!this.canLatchOn()) {
            return;
        }
        this.swets.add(EntityUtil.clone(swet));
        swet.func_70106_y();
    }

    @Override
    public void tickStart(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = this.getEntity();
        if (player.func_70090_H()) {
            this.detachSwets();
        }
        Iterator<EntitySwet> it = this.swets.iterator();
        while (it.hasNext()) {
            EntitySwet swet = it.next();
            if (!swet.processSucking(this.getEntity())) continue;
            it.remove();
            this.spawnSwet(swet);
        }
    }

    @Override
    public void tickEnd(TickEvent.PlayerTickEvent event) {
    }

    public void write(NBTTagCompound output) {
        NBTTagList list = new NBTTagList();
        for (EntitySwet swet : this.swets) {
            NBTTagCompound tag = new NBTTagCompound();
            swet.func_70014_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        output.func_74782_a("swets", (NBTBase)list);
    }

    public void read(NBTTagCompound input) {
        NBTTagList list = input.func_150295_c("swets", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            EntitySwet swet = new EntitySwet(this.getEntity().func_130014_f_());
            swet.func_70037_a(compound);
            this.swets.add(swet);
        }
    }

    @Override
    public ResourceLocation getIdentifier() {
        return AetherCore.getResource("swet");
    }
}

