/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player.modules;

import com.gildedgames.aether.api.world.preparation.IPrepManager;
import com.gildedgames.aether.api.world.preparation.IPrepRegistryEntry;
import com.gildedgames.aether.api.world.preparation.IPrepSector;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAetherModule;
import com.gildedgames.aether.common.world.preparation.PrepHelper;
import com.gildedgames.orbis.lib.util.ChunkMap;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerSectorModule
extends PlayerAetherModule {
    private final ChunkMap<WatchedSector> map = new ChunkMap();
    private Future<IPrepSector> waiting;

    public PlayerSectorModule(PlayerAether playerAether) {
        super(playerAether);
    }

    @Override
    public void tickStart(TickEvent.PlayerTickEvent event) {
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.update();
        this.processNext();
    }

    private void update() {
        for (WatchedSector loadEntry : this.map.getValues()) {
            loadEntry.updateDistance(this.getEntity());
            loadEntry.watching = false;
            if (loadEntry.sector == null) continue;
            loadEntry.sector.removeWatchingPlayer(this.getEntity().func_145782_y());
        }
        IPrepManager manager = PrepHelper.getManager(this.getWorld());
        if (manager == null) {
            return;
        }
        int radius = 80;
        IPrepRegistryEntry entry = manager.getRegistryEntry();
        int chunkX = (int)this.getEntity().field_70165_t >> 4;
        int chunkY = (int)this.getEntity().field_70161_v >> 4;
        int minChunkX = chunkX - radius;
        int minChunkY = chunkY - radius;
        int maxChunkX = chunkX + radius;
        int maxChunkY = chunkY + radius;
        int minSectorX = Math.floorDiv(minChunkX, entry.getSectorChunkArea());
        int minSectorY = Math.floorDiv(minChunkY, entry.getSectorChunkArea());
        int maxSectorX = Math.floorDiv(maxChunkX, entry.getSectorChunkArea());
        int maxSectorZ = Math.floorDiv(maxChunkY, entry.getSectorChunkArea());
        for (int x = minSectorX; x < maxSectorX; ++x) {
            for (int z = minSectorY; z < maxSectorZ; ++z) {
                WatchedSector watched;
                if (!this.map.containsKey(x, z)) {
                    watched = new WatchedSector(entry, x, z);
                    watched.updateDistance(this.getEntity());
                    watched.watching = true;
                    this.map.put(x, z, (Object)watched);
                    continue;
                }
                watched = (WatchedSector)this.map.get(x, z);
                watched.watching = true;
            }
        }
        if (this.waiting == null) {
            WatchedSector closest = null;
            for (WatchedSector watched : this.map.getValues()) {
                if (!watched.watching || watched.sector != null) continue;
                if (closest == null) {
                    closest = watched;
                    continue;
                }
                if (!(watched.distance < closest.distance)) continue;
                closest = watched;
            }
            if (closest != null) {
                this.waiting = manager.getAccess().provideSector(closest.sectorX, closest.sectorZ, true);
            }
        }
        ArrayList<WatchedSector> unload = new ArrayList<WatchedSector>();
        for (WatchedSector loadEntry : this.map.getValues()) {
            if (loadEntry.watching) continue;
            unload.add(loadEntry);
        }
        for (WatchedSector loadEntry : unload) {
            if (loadEntry.sector != null) {
                loadEntry.sector.removeWatchingPlayer(this.getEntity().func_145782_y());
            }
            this.map.remove(loadEntry.sectorX, loadEntry.sectorZ);
        }
    }

    public void releaseAll() {
        for (WatchedSector loadEntry : this.map.getValues()) {
            loadEntry.watching = false;
            if (loadEntry.sector == null) continue;
            loadEntry.sector.removeWatchingPlayer(this.getEntity().func_145782_y());
        }
        this.map.clear();
    }

    private void processNext() {
        if (this.waiting != null && this.waiting.isDone()) {
            try {
                IPrepSector sector = this.waiting.get();
                WatchedSector watched = (WatchedSector)this.map.get(sector.getData().getSectorX(), sector.getData().getSectorY());
                if (watched == null) {
                    return;
                }
                watched.sector = sector;
                IPrepManager manager = PrepHelper.getManager(this.getWorld());
                if (manager == null) {
                    return;
                }
                if (watched.watching) {
                    sector.addWatchingPlayer(this.getEntity().func_145782_y());
                    manager.getAccess().retainSector(sector);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Exception while generating AOT sector for player", e);
            }
            finally {
                this.waiting = null;
            }
        }
    }

    private class WatchedSector {
        private final int sectorX;
        private final int sectorZ;
        private IPrepSector sector;
        private final IPrepRegistryEntry entry;
        private boolean watching;
        private double distance;

        public WatchedSector(IPrepRegistryEntry entry, int sectorX, int sectorZ) {
            this.entry = entry;
            this.sectorX = sectorX;
            this.sectorZ = sectorZ;
        }

        public void updateDistance(EntityPlayer player) {
            double x = ((double)(this.sectorX * this.entry.getSectorChunkArea()) + (double)this.entry.getSectorChunkArea() / 2.0) * 16.0;
            double z = ((double)(this.sectorZ * this.entry.getSectorChunkArea()) + (double)this.entry.getSectorChunkArea() / 2.0) * 16.0;
            this.distance = player.func_70011_f(x, player.field_70163_u, z);
        }
    }
}

