/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player.modules;

import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAetherModule;
import com.gildedgames.aether.common.network.packets.PacketSpecialMovement;
import com.gildedgames.aether.common.util.helpers.AetherHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerRollMovementModule
extends PlayerAetherModule {
    private static final int MAX_ROLLING_TICKS = 12;
    private static final int ROLL_COOLDOWN_TICKS = 10;
    private boolean isRolling;
    private int ticksRolling;
    private int rollCooldown;
    private float startRotationYaw;
    private float rollingRotationYaw;
    private float prevStepHeight;
    private float prevEyeHeight;
    private float prevHeight;

    public PlayerRollMovementModule(PlayerAether playerAether) {
        super(playerAether);
    }

    public boolean isRolling() {
        return this.isRolling;
    }

    public int getTicksRolling() {
        return this.ticksRolling;
    }

    public int getTicksRollingMax() {
        return 12;
    }

    private void setEntityHeight(float height) {
        EntityPlayer p = this.getEntity();
        float w = p.field_70130_N / 2.0f;
        p.func_174826_a(new AxisAlignedBB(p.field_70165_t - (double)w, p.field_70163_u, p.field_70161_v - (double)w, p.field_70165_t + (double)w, p.field_70163_u + (double)height, p.field_70161_v + (double)w));
        p.field_70131_O = height;
        p.eyeHeight = height / this.prevHeight * this.prevEyeHeight;
    }

    protected final Vec3d getVectorForRotation(float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        return new Vec3d((double)(f1 * -1.0f), 0.0, (double)(f * -1.0f));
    }

    public boolean canRoll() {
        return AetherHelper.isEnabled(this.getWorld()) && this.rollCooldown <= 0 && !this.getEntity().func_70093_af() && this.getEntity().field_70122_E;
    }

    public float getDamageReduction(float inAmount) {
        return inAmount * (Math.abs((float)this.ticksRolling / 12.0f - 0.5f) * 2.0f);
    }

    public void startRolling(PacketSpecialMovement.Action action) {
        float angle;
        this.startRotationYaw = this.getEntity().field_70177_z;
        if (action == PacketSpecialMovement.Action.ROLL_FORWARD) {
            angle = 0.0f;
        } else if (action == PacketSpecialMovement.Action.ROLL_BACK) {
            angle = 180.0f;
        } else if (action == PacketSpecialMovement.Action.ROLL_LEFT) {
            angle = -90.0f;
        } else if (action == PacketSpecialMovement.Action.ROLL_RIGHT) {
            angle = 90.0f;
        } else {
            return;
        }
        this.rollingRotationYaw = this.startRotationYaw + angle;
        if (!this.canRoll()) {
            return;
        }
        this.prevStepHeight = this.getEntity().field_70138_W;
        this.prevHeight = this.getEntity().field_70131_O;
        this.prevEyeHeight = this.getEntity().func_70047_e();
        this.isRolling = true;
        this.ticksRolling = 0;
        this.rollCooldown = 10;
    }

    @Override
    public void tickStart(TickEvent.PlayerTickEvent event) {
        if (this.isRolling) {
            if (this.ticksRolling <= 12) {
                this.getEntity().field_70138_W = 1.0f;
                if (this.getEntity().field_70122_E) {
                    Vec3d vec = this.getVectorForRotation(this.getEntity().field_70177_z - this.startRotationYaw + this.rollingRotationYaw);
                    double speed = Math.max(0.0, Math.pow(1.25, (float)this.ticksRolling / 8.0f) - 1.0) + 0.25;
                    if ((float)this.ticksRolling > 8.4f && !this.getEntity().func_70051_ag()) {
                        speed = this.ticksRolling == 12 ? (double)0.05f : (speed /= (double)((float)this.ticksRolling / 12.0f * 5.0f));
                    }
                    this.getEntity().field_70159_w = vec.field_72450_a * speed;
                    this.getEntity().field_70179_y = vec.field_72449_c * speed;
                    this.getEntity().field_70133_I = true;
                }
                ++this.ticksRolling;
            } else {
                this.isRolling = false;
                this.ticksRolling = 0;
                this.getEntity().field_70138_W = this.prevStepHeight;
            }
        } else if (this.rollCooldown > 0) {
            --this.rollCooldown;
        }
    }

    @Override
    public void tickEnd(TickEvent.PlayerTickEvent event) {
        if (this.isRolling) {
            if (this.ticksRolling <= 12) {
                float newHeight = MathHelper.func_76131_a((float)(this.prevHeight / 4.0f + this.prevHeight * Math.abs((float)this.ticksRolling / 12.0f - 0.5f)), (float)(this.prevHeight / 2.0f), (float)this.prevHeight);
                this.setEntityHeight(newHeight);
            } else {
                this.setEntityHeight(this.prevHeight);
                this.getEntity().eyeHeight = this.prevEyeHeight;
            }
        }
    }
}

