/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player.modules;

import com.gildedgames.aether.api.player.IPlayerAetherModule;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAetherModule;
import com.gildedgames.aether.common.init.DimensionsAether;
import com.gildedgames.aether.common.items.IDropOnDeath;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerPreventDropsModule
extends PlayerAetherModule
implements IPlayerAetherModule.Serializable {
    public final NonNullList<ItemStack> mainInventory = NonNullList.func_191197_a((int)36, (Object)ItemStack.field_190927_a);
    public final NonNullList<ItemStack> armorInventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    public final NonNullList<ItemStack> offHandInventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);

    public PlayerPreventDropsModule(PlayerAether playerAether) {
        super(playerAether);
    }

    public static boolean shouldKeepOnDeath(ItemStack stack) {
        return !(stack.func_77973_b() instanceof ItemBlock) && !(stack.func_77973_b() instanceof ItemDoor) && !(stack.func_77973_b() instanceof ItemFood) && !(stack.func_77973_b() instanceof IDropOnDeath);
    }

    @Override
    public void onDeath(LivingDeathEvent event) {
        EntityPlayer player = (EntityPlayer)event.getEntity();
        if (player.field_70170_p.field_73011_w.func_186058_p() == DimensionsAether.AETHER && !player.func_130014_f_().func_82736_K().func_82766_b("keepInventory")) {
            this.setIfShouldKeep((List<ItemStack>)player.field_71071_by.field_70462_a, (List<ItemStack>)this.mainInventory, true);
            this.setIfShouldKeep((List<ItemStack>)player.field_71071_by.field_70460_b, (List<ItemStack>)this.armorInventory, true);
            this.setIfShouldKeep((List<ItemStack>)player.field_71071_by.field_184439_c, (List<ItemStack>)this.offHandInventory, true);
        }
    }

    public void setIfShouldKeep(List<ItemStack> from, List<ItemStack> to, boolean shouldKeepCheck) {
        for (int i = 0; i < from.size(); ++i) {
            ItemStack stack = from.get(i);
            if (shouldKeepCheck && !PlayerPreventDropsModule.shouldKeepOnDeath(stack)) continue;
            to.set(i, stack);
        }
    }

    @Override
    public void onDrops(PlayerDropsEvent event) {
        if (event.getEntityPlayer().field_70170_p.field_73011_w.func_186058_p() == DimensionsAether.AETHER && !event.getEntityPlayer().func_130014_f_().func_82736_K().func_82766_b("keepInventory")) {
            ArrayList toRemove = Lists.newArrayList();
            for (EntityItem item : event.getDrops()) {
                if (item == null || !PlayerPreventDropsModule.shouldKeepOnDeath(item.func_92059_d())) continue;
                toRemove.add(item);
            }
            event.getDrops().removeAll(toRemove);
        }
    }

    @Override
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        if (player.field_70170_p.field_73011_w.func_186058_p() == DimensionsAether.AETHER && !player.func_130014_f_().func_82736_K().func_82766_b("keepInventory")) {
            this.setIfShouldKeep((List<ItemStack>)this.mainInventory, (List<ItemStack>)player.field_71071_by.field_70462_a, false);
            this.setIfShouldKeep((List<ItemStack>)this.armorInventory, (List<ItemStack>)player.field_71071_by.field_70460_b, false);
            this.setIfShouldKeep((List<ItemStack>)this.offHandInventory, (List<ItemStack>)player.field_71071_by.field_184439_c, false);
            this.mainInventory.clear();
            this.armorInventory.clear();
            this.offHandInventory.clear();
        }
    }

    @Override
    public void tickStart(TickEvent.PlayerTickEvent event) {
    }

    @Override
    public void tickEnd(TickEvent.PlayerTickEvent event) {
    }

    public void write(NBTTagCompound nbtTagCompound) {
        NBTFunnel funnel = new NBTFunnel(nbtTagCompound);
        funnel.setStackList("mainInventory", this.mainInventory);
        funnel.setStackList("armorInventory", this.armorInventory);
        funnel.setStackList("offHandInventory", this.offHandInventory);
    }

    public void read(NBTTagCompound nbtTagCompound) {
        NBTFunnel funnel = new NBTFunnel(nbtTagCompound);
        List mainInventory = funnel.getStackList("mainInventory");
        List armorInventory = funnel.getStackList("armorInventory");
        List offHandInventory = funnel.getStackList("offHandInventory");
        this.setIfShouldKeep(mainInventory, (List<ItemStack>)this.mainInventory, false);
        this.setIfShouldKeep(armorInventory, (List<ItemStack>)this.armorInventory, false);
        this.setIfShouldKeep(offHandInventory, (List<ItemStack>)this.offHandInventory, false);
    }

    @Override
    public ResourceLocation getIdentifier() {
        return AetherCore.getResource("drops");
    }
}

