/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player.modules;

import com.gildedgames.aether.api.player.IPlayerAetherModule;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAetherModule;
import com.gildedgames.aether.common.entities.blocks.EntityParachute;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerParachuteModule
extends PlayerAetherModule
implements IPlayerAetherModule.Serializable {
    private boolean isParachuting;
    private boolean parachuteEquipped;
    public ItemStack parachuteItem;
    private EntityParachute.Type type = EntityParachute.Type.COLD;
    private int hitAmnt;
    private boolean prevAllowFlying;
    private int parachuteItemSlot = -1;

    public PlayerParachuteModule(PlayerAether playerAether) {
        super(playerAether);
    }

    @Override
    public void tickStart(TickEvent.PlayerTickEvent event) {
        if (this.isParachuting) {
            int x = MathHelper.func_76128_c((double)this.getEntity().field_70165_t);
            int y = MathHelper.func_76128_c((double)this.getEntity().field_70163_u);
            int z = MathHelper.func_76128_c((double)this.getEntity().field_70161_v);
            Vec3d vec3 = this.getEntity().func_70040_Z();
            this.getEntity().field_70143_R = 0.0f;
            if (!this.isParachuting) {
                this.hitAmnt = 0;
            } else if (this.getEntity().field_110158_av >= 4 && this.isParachuting && vec3.field_72448_b >= 1.0 && !this.getEntity().field_70122_E) {
                ++this.hitAmnt;
            }
            if (this.getParachuteType() != EntityParachute.Type.BLUE && (!this.getEntity().field_70170_p.func_175623_d(new BlockPos(x, y - 1, z)) || !this.isParachuting) || this.isParachuting && this.hitAmnt >= 4) {
                this.setParachuting(false, this.type);
            }
        }
    }

    public void setParachuting(boolean isParachuting, EntityParachute.Type type) {
        this.isParachuting = isParachuting;
        this.type = type;
    }

    public boolean isUnderABlock(int y) {
        AxisAlignedBB boundingBox = this.getEntity().func_174813_aQ();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x1 = (int)Math.floor(boundingBox.field_72340_a); x1 <= (int)Math.ceil(boundingBox.field_72336_d); ++x1) {
            for (int z1 = (int)Math.floor(boundingBox.field_72339_c); z1 <= (int)Math.ceil(boundingBox.field_72334_f); ++z1) {
                if (this.getEntity().field_70170_p.func_175623_d((BlockPos)pos.func_181079_c(x1, y + 1, z1)) && this.getEntity().field_70170_p.func_175623_d((BlockPos)pos.func_181079_c(x1, y + 2, z1))) continue;
                return true;
            }
        }
        return false;
    }

    public void parachuteEquipped(boolean equipped) {
        this.parachuteEquipped = equipped;
    }

    public boolean getParachuteEquipped() {
        return this.parachuteEquipped;
    }

    public void parachuteItem(ItemStack stack) {
        this.parachuteItem = stack;
    }

    public int getParachuteItemSlot() {
        return this.parachuteItemSlot;
    }

    public void parachuteItemSlot(int slot) {
        this.parachuteItemSlot = slot;
    }

    public ItemStack getParachuteItem() {
        return this.parachuteItem;
    }

    public EntityParachute.Type getParachuteType() {
        return this.type;
    }

    public boolean isParachuting() {
        return this.isParachuting;
    }

    public void write(NBTTagCompound output) {
        NBTTagCompound root = new NBTTagCompound();
        output.func_74782_a("Parachute", (NBTBase)root);
        root.func_74757_a("parachuting", this.isParachuting);
        root.func_74768_a("type", this.type.ordinal());
        root.func_74757_a("prevAllowFlying", this.prevAllowFlying);
    }

    public void read(NBTTagCompound input) {
        NBTTagCompound root = input.func_74775_l("Parachute");
        this.isParachuting = input.func_74767_n("parachuting");
        this.type = EntityParachute.Type.fromOrdinal(input.func_74762_e("type"));
        this.prevAllowFlying = input.func_74767_n("prevAllowFlying");
    }

    @Override
    public ResourceLocation getIdentifier() {
        return AetherCore.getResource("parachute");
    }
}

