/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player.modules;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.items.EffectActivator;
import com.gildedgames.aether.api.items.equipment.effects.IEffectFactory;
import com.gildedgames.aether.api.items.equipment.effects.IEffectPool;
import com.gildedgames.aether.api.items.equipment.effects.IEffectProvider;
import com.gildedgames.aether.api.items.properties.IItemProperties;
import com.gildedgames.aether.api.player.IEquipmentModule;
import com.gildedgames.aether.api.player.IPlayerAetherModule;
import com.gildedgames.aether.api.player.inventory.IInventoryEquipment;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAetherModule;
import com.gildedgames.aether.common.containers.inventory.InventoryEquipment;
import com.gildedgames.aether.common.entities.effects.EquipmentEffectPool;
import com.gildedgames.aether.common.entities.effects.InventoryProvider;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketEquipment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public class PlayerEquipmentModule
extends PlayerAetherModule
implements IEquipmentModule,
IPlayerAetherModule.Serializable {
    private static final InventoryProvider EQUIPMENT_INV_PROVIDER = new InventoryProvider(AetherCore.getResource("equipmentInv"), playerAether -> playerAether.getModule(PlayerEquipmentModule.class).getInventory());
    private static final InventoryProvider NORMAL_INV_PROVIDER = new InventoryProvider(AetherCore.getResource("normalInv"), playerAether -> playerAether.getEntity().field_71071_by);
    private final InventoryEquipment stagingInv;
    private final InventoryEquipment recordedInv;
    private final Map<ResourceLocation, EquipmentEffectPool<IEffectProvider>> pools = new HashMap<ResourceLocation, EquipmentEffectPool<IEffectProvider>>();
    private ItemStack lastHeldStack = ItemStack.field_190927_a;
    private int lastHeldStackIndex = -1;

    public PlayerEquipmentModule(PlayerAether player) {
        super(player);
        this.stagingInv = new InventoryEquipment(player);
        this.recordedInv = new InventoryEquipment(player);
    }

    @Override
    public void tickStart(TickEvent.PlayerTickEvent event) {
        ItemStack mainHeldStack = this.getEntity().func_184614_ca();
        int mainHeldStackIndex = this.getSlotFor(mainHeldStack);
        if (this.lastHeldStackIndex != -1) {
            if (!(this.lastHeldStackIndex == mainHeldStackIndex && this.lastHeldStack.func_190926_b() || ItemStack.func_77989_b((ItemStack)this.lastHeldStack, (ItemStack)mainHeldStack))) {
                this.deactivateEquipmentEffects(this.lastHeldStack, (Pair<Integer, InventoryProvider>)Pair.of((Object)this.lastHeldStackIndex, (Object)NORMAL_INV_PROVIDER), EffectActivator.WHEN_HELD);
            }
            if (mainHeldStack.func_190926_b()) {
                this.deactivateEquipmentEffects(this.lastHeldStack, (Pair<Integer, InventoryProvider>)Pair.of((Object)mainHeldStackIndex, (Object)NORMAL_INV_PROVIDER), EffectActivator.WHEN_HELD);
                if (this.lastHeldStackIndex != mainHeldStackIndex) {
                    for (int i = 0; i < this.getEntity().field_71071_by.func_70302_i_(); ++i) {
                        this.deactivateEquipmentEffects(this.getEntity().field_71071_by.func_70301_a(i), (Pair<Integer, InventoryProvider>)Pair.of((Object)this.lastHeldStackIndex, (Object)NORMAL_INV_PROVIDER), EffectActivator.WHEN_HELD);
                    }
                }
            }
        }
        if (!mainHeldStack.func_190926_b() && !ItemStack.func_77989_b((ItemStack)this.lastHeldStack, (ItemStack)mainHeldStack)) {
            this.activateEquipmentEffects(mainHeldStack, (Pair<Integer, InventoryProvider>)Pair.of((Object)mainHeldStackIndex, (Object)NORMAL_INV_PROVIDER), EffectActivator.WHEN_HELD);
        }
        this.lastHeldStack = this.getEntity().func_184614_ca();
        this.lastHeldStackIndex = this.getSlotFor(this.lastHeldStack);
        ArrayList<Pair<Integer, ItemStack>> updates = this.getEntity().field_70170_p.field_72995_K ? null : new ArrayList<Pair<Integer, ItemStack>>();
        for (int i = 0; i < this.stagingInv.func_70302_i_(); ++i) {
            ItemStack newStack;
            ItemStack oldStack = this.recordedInv.func_70301_a(i);
            if (ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)(newStack = this.stagingInv.func_70301_a(i)))) continue;
            if (!oldStack.func_190926_b()) {
                this.deactivateEquipmentEffects(oldStack, (Pair<Integer, InventoryProvider>)Pair.of((Object)i, (Object)EQUIPMENT_INV_PROVIDER), EffectActivator.WHEN_EQUIPPED);
            }
            if (!newStack.func_190926_b()) {
                this.activateEquipmentEffects(newStack, (Pair<Integer, InventoryProvider>)Pair.of((Object)i, (Object)EQUIPMENT_INV_PROVIDER), EffectActivator.WHEN_EQUIPPED);
            }
            if (updates != null) {
                updates.add((Pair<Integer, ItemStack>)Pair.of((Object)i, (Object)newStack));
            }
            this.recordedInv.func_70299_a(i, newStack.func_190926_b() ? ItemStack.field_190927_a : newStack.func_77946_l());
        }
        if (updates != null && !updates.isEmpty()) {
            NetworkingAether.sendPacketToWatching(new PacketEquipment((Entity)this.getEntity(), updates), (EntityLivingBase)this.getEntity(), true);
        }
        this.pools.values().forEach(EquipmentEffectPool::update);
    }

    private int getSlotFor(ItemStack stack) {
        for (int i = 0; i < this.getEntity().field_71071_by.field_70462_a.size(); ++i) {
            if (((ItemStack)this.getEntity().field_71071_by.field_70462_a.get(i)).func_190926_b() || !this.stackEqualExact(stack, (ItemStack)this.getEntity().field_71071_by.field_70462_a.get(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public void write(NBTTagCompound compound) {
        NBTTagCompound equipment = new NBTTagCompound();
        compound.func_74782_a("EquipmentInventory", (NBTBase)equipment);
        this.stagingInv.write(equipment);
    }

    public void read(NBTTagCompound compound) {
        if (compound.func_74764_b("EquipmentInventory")) {
            this.stagingInv.read(compound.func_74775_l("EquipmentInventory"));
        }
    }

    private void activateEquipmentEffects(ItemStack stack, Pair<Integer, InventoryProvider> inventoryIndexPair, EffectActivator activator) {
        IItemProperties properties = AetherAPI.content().items().getProperties(stack.func_77973_b());
        if (!properties.getEffectActivators().contains((Object)activator)) {
            return;
        }
        properties.getEffectProviders().forEach(provider -> {
            EquipmentEffectPool pool = this.pools.computeIfAbsent(provider.getFactory(), key -> new EquipmentEffectPool<IEffectProvider>(this.getPlayer(), AetherAPI.content().effects().getFactory((ResourceLocation)key)));
            IEffectProvider copy = provider.copy();
            Validate.isTrue((copy != provider ? 1 : 0) != 0, (String)"IEffectProvider#copy() cannot return itself", (Object[])new Object[0]);
            pool.addInstance(inventoryIndexPair, copy);
        });
    }

    private void deactivateEquipmentEffects(ItemStack stack, Pair<Integer, InventoryProvider> inventoryIndexPair, EffectActivator activator) {
        IItemProperties properties = AetherAPI.content().items().getProperties(stack.func_77973_b());
        if (!properties.getEffectActivators().contains((Object)activator)) {
            return;
        }
        this.pools.entrySet().removeIf(pair -> {
            EquipmentEffectPool pool = (EquipmentEffectPool)pair.getValue();
            pool.removeInstances(inventoryIndexPair);
            return pool.isEmpty();
        });
    }

    @Override
    public Optional<IEffectPool<IEffectProvider>> getEffectPool(ResourceLocation id) {
        return Optional.ofNullable(this.pools.get(id));
    }

    public Collection<IEffectPool<IEffectProvider>> getActivePools() {
        return Collections.unmodifiableCollection(this.pools.values());
    }

    public void onTeleport() {
        this.pools.values().forEach(EquipmentEffectPool::onTeleport);
    }

    @Override
    public IInventoryEquipment getInventory() {
        return this.stagingInv;
    }

    @Override
    public boolean isEffectActive(IEffectFactory<?> effect) {
        Optional<IEffectPool<IEffectProvider>> pool = this.getEffectPool(effect.getIdentifier());
        return pool.isPresent() && !pool.get().isEmpty();
    }

    @Override
    public ResourceLocation getIdentifier() {
        return AetherCore.getResource("equipment");
    }
}

