/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.common.capabilities.entity.player.modules;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.dialog.IDialogAction;
import com.gildedgames.aether.api.dialog.IDialogButton;
import com.gildedgames.aether.api.dialog.IDialogChangeListener;
import com.gildedgames.aether.api.dialog.IDialogCondition;
import com.gildedgames.aether.api.dialog.IDialogController;
import com.gildedgames.aether.api.dialog.IDialogLine;
import com.gildedgames.aether.api.dialog.IDialogNode;
import com.gildedgames.aether.api.dialog.IDialogScene;
import com.gildedgames.aether.api.dialog.ISceneInstance;
import com.gildedgames.aether.api.entity.EntityCharacter;
import com.gildedgames.aether.client.gui.dialog.GuiDialogViewer;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAetherModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.SceneInstance;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.dialog.PacketActivateButton;
import com.gildedgames.aether.common.network.packets.dialog.PacketAdvance;
import com.gildedgames.aether.common.network.packets.dialog.PacketCloseScene;
import com.gildedgames.aether.common.network.packets.dialog.PacketNavigateBack;
import com.gildedgames.aether.common.network.packets.dialog.PacketNavigateNode;
import com.gildedgames.aether.common.network.packets.dialog.PacketOpenDialog;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public class PlayerDialogModule
extends PlayerAetherModule
implements IDialogController {
    private final Set<IDialogChangeListener> listeners = new HashSet<IDialogChangeListener>();
    private ISceneInstance sceneInstance;
    private String lastNodeId;
    private EntityCharacter talkingEntity;
    private Map<String, Boolean> conditionsMet;

    public PlayerDialogModule(PlayerAether playerAether) {
        super(playerAether);
    }

    @Override
    public void setConditionsMetData(Map<String, Boolean> conditionsMet) {
        this.conditionsMet = conditionsMet;
        if (this.sceneInstance != null) {
            this.sceneInstance.setConditionsMet(conditionsMet);
        }
    }

    @Override
    public EntityPlayer getDialogPlayer() {
        return this.getEntity();
    }

    protected void updateListeners() {
        for (IDialogChangeListener listener : this.listeners) {
            listener.onDialogChanged();
        }
    }

    @Override
    @Nullable
    public EntityCharacter getTalkingCharacter() {
        return this.talkingEntity;
    }

    @Override
    public void setTalkingEntity(EntityCharacter entity) {
        this.talkingEntity = entity;
    }

    @Override
    public void addListener(IDialogChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void openScene(ResourceLocation path, String startingNodeId) {
        IDialogScene scene = AetherAPI.content().dialog().getScene(path).orElseThrow(() -> new IllegalArgumentException("Couldn't getByte scene " + path));
        scene.setStartingNode(startingNodeId);
        if (this.getPlayer().getEntity().field_70170_p.field_72995_K) {
            this.openSceneClient(path, scene, this.conditionsMet);
        } else {
            this.openSceneServer(path, scene);
        }
        this.updateListeners();
    }

    @Override
    public IDialogScene getCurrentScene() {
        return this.sceneInstance != null ? this.sceneInstance.getScene() : null;
    }

    @Override
    public ISceneInstance getCurrentSceneInstance() {
        return this.sceneInstance;
    }

    @SideOnly(value=Side.CLIENT)
    private void openSceneClient(ResourceLocation res, IDialogScene scene, Map<String, Boolean> conditionsMet) {
        this.sceneInstance = new SceneInstance(this, scene, conditionsMet);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDialogViewer((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this, this.sceneInstance));
    }

    private void openSceneServer(ResourceLocation res, IDialogScene scene) {
        this.sceneInstance = new SceneInstance(this, scene);
        NetworkingAether.sendPacketToPlayer(new PacketOpenDialog(res, scene.getStartingNode().getIdentifier(), this.sceneInstance.getConditionsMet()), (EntityPlayerMP)this.getPlayer().getEntity());
    }

    @SideOnly(value=Side.CLIENT)
    public void navigateNodeClient(String nodeId) {
        if (this.sceneInstance.getNode() != null) {
            this.lastNodeId = this.sceneInstance.getNode().getIdentifier();
        }
        this.sceneInstance.navigate(nodeId);
    }

    @SideOnly(value=Side.CLIENT)
    public void navigateBackClient() {
        if (this.lastNodeId != null) {
            this.sceneInstance.navigate(this.lastNodeId);
            while (!this.isNodeFinished()) {
                this.advance();
            }
        }
    }

    @Override
    public void navigateNode(String nodeId) {
        if (!this.getWorld().field_72995_K) {
            if (this.sceneInstance.getNode() != null) {
                this.lastNodeId = this.sceneInstance.getNode().getIdentifier();
            }
            this.sceneInstance.navigate(nodeId);
            NetworkingAether.sendPacketToPlayer(new PacketNavigateNode(nodeId), (EntityPlayerMP)this.getDialogPlayer());
        }
    }

    @Override
    public void navigateBack() {
        if (!this.getWorld().field_72995_K) {
            NetworkingAether.sendPacketToPlayer(new PacketNavigateBack(), (EntityPlayerMP)this.getDialogPlayer());
            if (this.lastNodeId != null) {
                this.sceneInstance.navigate(this.lastNodeId);
                while (!this.isNodeFinished()) {
                    this.advance();
                }
            }
        }
    }

    @Override
    public boolean conditionsMet(IDialogButton button) {
        if (this.getWorld().field_72995_K) {
            if (this.sceneInstance == null) {
                throw new NullPointerException("Scene instance is null in activateButton()");
            }
            if (!this.sceneInstance.getConditionsMet().containsKey(button.getLabel())) {
                return false;
            }
            return this.sceneInstance.getConditionsMet().get(button.getLabel());
        }
        boolean flag = false;
        for (IDialogCondition condition : button.getOrConditions()) {
            if (!condition.isMet(this)) continue;
            flag = true;
            break;
        }
        for (IDialogCondition condition : button.getConditions()) {
            if (!condition.isMet(this)) {
                flag = false;
                break;
            }
            flag = true;
        }
        return flag || button.getConditions().isEmpty() && button.getOrConditions().isEmpty();
    }

    @Override
    public void activateButton(IDialogButton button) {
        Validate.isTrue((boolean)this.sceneInstance.getNode().getButtons().contains(button));
        if (this.getWorld().field_72995_K) {
            NetworkingAether.sendPacketToServer(new PacketActivateButton(button.getLabel()));
        }
        if (!this.conditionsMet(button)) {
            return;
        }
        if (!this.getWorld().field_72995_K) {
            NetworkingAether.sendPacketToPlayer(new PacketActivateButton(button.getLabel()), (EntityPlayerMP)this.getEntity());
            Collection<IDialogAction> actions = button.getActions();
            for (IDialogAction action : actions) {
                action.performAction(this);
            }
        }
    }

    public void advanceClient() {
        if (this.sceneInstance != null) {
            this.sceneInstance.forwards();
        }
    }

    @Override
    public void advance() {
        if (this.getWorld().field_72995_K) {
            NetworkingAether.sendPacketToServer(new PacketAdvance());
        } else {
            NetworkingAether.sendPacketToPlayer(new PacketAdvance(), (EntityPlayerMP)this.getDialogPlayer());
            if (this.sceneInstance != null) {
                this.sceneInstance.forwards();
            }
        }
    }

    @Override
    public IDialogNode getCurrentNode() {
        return this.sceneInstance.getNode();
    }

    @Override
    public IDialogLine getCurrentLine() {
        return this.sceneInstance.getLine();
    }

    @Override
    public boolean isNodeFinished() {
        if (this.sceneInstance == null) {
            return false;
        }
        return this.sceneInstance.isDoneReading();
    }

    @Override
    public void closeScene(ISceneInstance sceneInstance) {
        if (this.sceneInstance != sceneInstance) {
            return;
        }
        for (IDialogChangeListener listener : this.listeners) {
            listener.beforeSceneCloses();
        }
        this.listeners.clear();
        this.sceneInstance = null;
        if (this.getWorld().field_72995_K) {
            NetworkingAether.sendPacketToServer(new PacketCloseScene());
        }
    }

    public void closeCurrentScene() {
        this.closeScene(this.getCurrentSceneInstance());
    }
}

